/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.client.support.VersionUtils;
import org.springframework.cloud.dataflow.rest.resource.CurrentTaskExecutionsResource;
import org.springframework.cloud.dataflow.rest.resource.LauncherResource;
import org.springframework.cloud.dataflow.rest.resource.TaskAppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.TaskDefinitionResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TaskTemplate
implements TaskOperations {
    static final String DEFINITIONS_RELATION = "tasks/definitions";
    private static final String DEFINITION_RELATION = "tasks/definitions/definition";
    private static final String EXECUTIONS_CURRENT_RELATION_VERSION = "1.7.0";
    private static final String VALIDATION_RELATION_VERSION = "1.7.0";
    private static final String EXECUTIONS_RELATION = "tasks/executions";
    private static final String EXECUTIONS_CURRENT_RELATION = "tasks/executions/current";
    private static final String EXECUTION_RELATION = "tasks/executions/execution";
    private static final String EXECUTION_RELATION_BY_NAME = "tasks/executions/name";
    private static final String VALIDATION_REL = "tasks/validation";
    private static final String PLATFORM_LIST_RELATION = "tasks/platforms";
    private static final String RETRIEVE_LOG = "tasks/logs";
    private final RestTemplate restTemplate;
    private final Link definitionsLink;
    private final Link definitionLink;
    private final Link executionsLink;
    private final Link executionLink;
    private final Link executionByNameLink;
    private final Link executionsCurrentLink;
    private final Link validationLink;
    private final Link platformListLink;
    private final String dataFlowServerVersion;
    private final Link retrieveLogLink;

    TaskTemplate(RestTemplate restTemplate, RepresentationModel<?> resources, String dataFlowServerVersion) {
        Assert.notNull(resources, (String)"URI CollectionModel must not be be null");
        Assert.notNull((Object)resources.getLink(EXECUTIONS_RELATION), (String)"Executions relation is required");
        Assert.notNull((Object)resources.getLink(DEFINITIONS_RELATION), (String)"Definitions relation is required");
        Assert.notNull((Object)resources.getLink(DEFINITION_RELATION), (String)"Definition relation is required");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        Assert.notNull((Object)resources.getLink(EXECUTIONS_RELATION), (String)"Executions relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION), (String)"Execution relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION_BY_NAME), (String)"Execution by name relation is required");
        Assert.notNull((Object)dataFlowServerVersion, (String)"dataFlowVersion must not be null");
        Assert.notNull((Object)resources.getLink(RETRIEVE_LOG), (String)"Log relation is required");
        this.dataFlowServerVersion = dataFlowServerVersion;
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(VersionUtils.getThreePartVersion(dataFlowServerVersion), "1.7.0")) {
            Assert.notNull((Object)resources.getLink(VALIDATION_REL), (String)"Validiation relation for tasks is required");
        }
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(VersionUtils.getThreePartVersion(dataFlowServerVersion), "1.7.0")) {
            Assert.notNull((Object)resources.getLink(EXECUTIONS_CURRENT_RELATION), (String)"Executions current relation is required");
        }
        this.restTemplate = restTemplate;
        this.definitionsLink = (Link)resources.getLink(DEFINITIONS_RELATION).get();
        this.definitionLink = (Link)resources.getLink(DEFINITION_RELATION).get();
        this.executionsLink = (Link)resources.getLink(EXECUTIONS_RELATION).get();
        this.executionLink = (Link)resources.getLink(EXECUTION_RELATION).get();
        this.executionByNameLink = (Link)resources.getLink(EXECUTION_RELATION_BY_NAME).get();
        this.executionsCurrentLink = (Link)resources.getLink(EXECUTIONS_CURRENT_RELATION).get();
        this.validationLink = (Link)resources.getLink(VALIDATION_REL).get();
        this.platformListLink = (Link)resources.getLink(PLATFORM_LIST_RELATION).get();
        this.retrieveLogLink = (Link)resources.getLink(RETRIEVE_LOG).get();
    }

    public TaskDefinitionResource.Page list() {
        String uriTemplate = this.definitionsLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (TaskDefinitionResource.Page)this.restTemplate.getForObject(uriTemplate, TaskDefinitionResource.Page.class, new Object[0]);
    }

    public LauncherResource.Page listPlatforms() {
        String uriTemplate = this.platformListLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (LauncherResource.Page)this.restTemplate.getForObject(uriTemplate, LauncherResource.Page.class, new Object[0]);
    }

    @Override
    public TaskDefinitionResource create(String name, String definition, String description) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"name", (Object)name);
        values.add((Object)"definition", (Object)definition);
        values.add((Object)"description", (Object)description);
        return (TaskDefinitionResource)this.restTemplate.postForObject(this.definitionsLink.expand(new Object[0]).getHref(), (Object)values, TaskDefinitionResource.class, new Object[0]);
    }

    @Override
    public long launch(String name, Map<String, String> properties, List<String> arguments, String alternateComposedTaskRunnerApp) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"properties", (Object)DeploymentPropertiesUtils.format(properties));
        values.add((Object)"arguments", (Object)StringUtils.collectionToDelimitedString(arguments, (String)" "));
        if (alternateComposedTaskRunnerApp != null) {
            values.add((Object)"ctrname", (Object)alternateComposedTaskRunnerApp);
        }
        return (Long)this.restTemplate.postForObject(this.executionByNameLink.expand(new Object[]{name}).getHref(), (Object)values, Long.class, new Object[]{name});
    }

    @Override
    public void stop(String ids) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        this.restTemplate.postForLocation(this.executionLink.expand(new Object[]{ids}).getHref(), (Object)values, new Object[0]);
    }

    @Override
    public void stop(String ids, String platform) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"platform", (Object)platform);
        this.restTemplate.postForLocation(this.executionLink.expand(new Object[]{ids}).getHref(), (Object)values, new Object[0]);
    }

    @Override
    public void destroy(String name) {
        this.restTemplate.delete(this.definitionLink.expand(new Object[]{name}).getHref(), Collections.singletonMap("name", name));
    }

    @Override
    public void destroyAll() {
        this.restTemplate.delete(this.definitionsLink.getHref(), new Object[0]);
    }

    public TaskExecutionResource.Page executionList() {
        return (TaskExecutionResource.Page)this.restTemplate.getForObject(this.executionsLink.getHref(), TaskExecutionResource.Page.class, new Object[0]);
    }

    public TaskExecutionResource.Page executionListByTaskName(String taskName) {
        return (TaskExecutionResource.Page)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{taskName}).getHref(), TaskExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public TaskExecutionResource taskExecutionStatus(long id) {
        return (TaskExecutionResource)this.restTemplate.getForObject(this.executionLink.expand(new Object[]{id}).getHref(), TaskExecutionResource.class, new Object[0]);
    }

    @Override
    public String taskExecutionLog(String externalExecutionId) {
        return this.taskExecutionLog(externalExecutionId, "default");
    }

    @Override
    public String taskExecutionLog(String externalExecutionId, String platform) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskExternalExecutionId", externalExecutionId);
        map.put("platformName", platform);
        return (String)this.restTemplate.getForObject(this.retrieveLogLink.expand(map).getHref(), String.class, new Object[0]);
    }

    @Override
    public Collection<CurrentTaskExecutionsResource> currentTaskExecutions() {
        ParameterizedTypeReference<Collection<CurrentTaskExecutionsResource>> typeReference = new ParameterizedTypeReference<Collection<CurrentTaskExecutionsResource>>(){};
        return (Collection)this.restTemplate.exchange(this.executionsCurrentLink.getHref(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]).getBody();
    }

    @Override
    public void cleanup(long id) {
        this.restTemplate.delete(this.executionLink.expand(new Object[]{id}).getHref(), new Object[0]);
    }

    @Override
    public TaskAppStatusResource validateTaskDefinition(String taskDefinitionName) throws OperationNotSupportedException {
        if (this.validationLink == null) {
            throw new OperationNotSupportedException("Task Validation not supported on Data Flow Server version " + this.dataFlowServerVersion);
        }
        String uriTemplate = this.validationLink.expand(new Object[]{taskDefinitionName}).getHref();
        return (TaskAppStatusResource)this.restTemplate.getForObject(uriTemplate, TaskAppStatusResource.class, new Object[0]);
    }
}

