/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.config;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.common.security.core.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.config.DataFlowClientProperties;
import org.springframework.cloud.dataflow.rest.client.dsl.Stream;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamBuilder;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={DataFlowClientProperties.class})
public class DataFlowClientAutoConfiguration {
    private static Log logger = LogFactory.getLog(DataFlowClientAutoConfiguration.class);
    private static final String DEFAULT_REGISTRATION_ID = "default";
    @Autowired
    private DataFlowClientProperties properties;
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Autowired
    @Nullable
    private ClientRegistrationRepository clientRegistrations;
    @Autowired
    @Nullable
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;

    @Bean
    @ConditionalOnMissingBean(value={DataFlowOperations.class})
    public DataFlowOperations dataFlowOperations() throws Exception {
        RestTemplate template = DataFlowTemplate.prepareRestTemplate(this.restTemplate);
        HttpClientConfigurer httpClientConfigurer = HttpClientConfigurer.create((URI)new URI(this.properties.getServerUri())).skipTlsCertificateVerification(this.properties.isSkipSslValidation());
        if (StringUtils.hasText((String)this.properties.getAuthentication().getAccessToken())) {
            template.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(this.properties.getAuthentication().getAccessToken()));
            logger.debug((Object)"Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.properties.getAuthentication().getClientId())) {
            ClientRegistration clientRegistration = this.clientRegistrations.findByRegistrationId(DEFAULT_REGISTRATION_ID);
            OAuth2ClientCredentialsGrantRequest grantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
            OAuth2AccessTokenResponse res = this.clientCredentialsTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
            String accessTokenValue = res.getAccessToken().getTokenValue();
            template.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(accessTokenValue));
            logger.debug((Object)"Configured OAuth2 Client Credentials for accessing the Data Flow Server");
        } else if (!StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getUsername()) && !StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getPassword())) {
            httpClientConfigurer.basicAuthCredentials(this.properties.getAuthentication().getBasic().getUsername(), this.properties.getAuthentication().getBasic().getPassword());
            template.setRequestFactory(httpClientConfigurer.buildClientHttpRequestFactory());
        } else {
            logger.debug((Object)"Not configuring security for accessing the Data Flow Server");
        }
        return new DataFlowTemplate(new URI(this.properties.getServerUri()), template);
    }

    @Bean
    @ConditionalOnMissingBean(value={StreamBuilder.class})
    public StreamBuilder streamBuilder(DataFlowOperations dataFlowOperations) {
        return Stream.builder(dataFlowOperations);
    }

    @ConditionalOnProperty(prefix="spring.cloud.dataflow.client.authentication", name={"client-id"})
    @Configuration
    static class ClientCredentialsConfiguration {
        ClientCredentialsConfiguration() {
        }

        @Bean
        public InMemoryClientRegistrationRepository clientRegistrationRepository(DataFlowClientProperties properties) {
            ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)DataFlowClientAutoConfiguration.DEFAULT_REGISTRATION_ID).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).tokenUri(properties.getAuthentication().getTokenUri()).clientId(properties.getAuthentication().getClientId()).clientSecret(properties.getAuthentication().getClientSecret()).scope(properties.getAuthentication().getScope()).build();
            return new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        }

        @Bean
        OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient() {
            return new DefaultClientCredentialsTokenResponseClient();
        }
    }
}

