/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.DockerCommandBuilder;
import org.springframework.cloud.deployer.spi.local.JavaCommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLocalDeployerSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocalDeployerProperties properties;
    private final RestTemplate restTemplate = new RestTemplate();
    private final JavaCommandBuilder javaCommandBuilder;
    private final DockerCommandBuilder dockerCommandBuilder;

    public AbstractLocalDeployerSupport(LocalDeployerProperties properties) {
        Assert.notNull((Object)properties, (String)"LocalDeployerProperties must not be null");
        this.properties = properties;
        this.javaCommandBuilder = new JavaCommandBuilder(properties);
        this.dockerCommandBuilder = new DockerCommandBuilder();
    }

    protected final LocalDeployerProperties getLocalDeployerProperties() {
        return this.properties;
    }

    protected void retainEnvVars(Set<String> vars) {
        String[] patterns = this.getLocalDeployerProperties().getEnvVarsToInherit();
        Iterator<String> iterator = vars.iterator();
        while (iterator.hasNext()) {
            String var = iterator.next();
            boolean retain = false;
            for (String pattern : patterns) {
                if (!Pattern.matches(pattern, var)) continue;
                retain = true;
                break;
            }
            if (retain) continue;
            iterator.remove();
        }
    }

    protected ProcessBuilder buildProcessBuilder(AppDeploymentRequest request, Map<String, String> args) {
        Assert.notNull((Object)request, (String)"AppDeploymentRequest must be set");
        Assert.notNull(args, (String)"Args must be set");
        String[] commands = null;
        commands = request.getResource() instanceof DockerResource ? this.dockerCommandBuilder.buildExecutionCommand(request, args) : this.javaCommandBuilder.buildExecutionCommand(request, args);
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.retainEnvVars(builder.environment().keySet());
        builder.environment().putAll(args);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAndWait(Instance instance) {
        try {
            ResponseEntity response;
            int timeout = this.getLocalDeployerProperties().getShutdownTimeout();
            if (timeout > 0 && (response = this.restTemplate.postForEntity(instance.getBaseUrl() + "/shutdown", null, String.class, new Object[0])).getStatusCode().is2xxSuccessful()) {
                long timeoutTimestamp = System.currentTimeMillis() + (long)(timeout * 1000);
                while (AbstractLocalDeployerSupport.isAlive(instance.getProcess()) && System.currentTimeMillis() < timeoutTimestamp) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            if (AbstractLocalDeployerSupport.isAlive(instance.getProcess())) {
                instance.getProcess().destroy();
            }
        }
    }

    protected static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static interface Instance {
        public URL getBaseUrl();

        public Process getProcess();
    }
}

