/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;

public class DockerCommandBuilder
implements CommandBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String[] buildExecutionCommand(AppDeploymentRequest request, Map<String, String> args) {
        List<String> commands = this.addDockerOptions(request, args);
        this.logger.debug("Docker Command = " + commands);
        return commands.toArray(new String[0]);
    }

    private List<String> addDockerOptions(AppDeploymentRequest request, Map<String, String> args) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("docker");
        commands.add("run");
        DockerResource dockerResource = (DockerResource)request.getResource();
        for (Map.Entry<String, String> entry : args.entrySet()) {
            if (entry.getKey().equals("server.port")) {
                commands.add("-p");
                commands.add(String.format("%s:8080", args.get(entry.getKey())));
                continue;
            }
            commands.add("-e");
            commands.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        try {
            String dockerImageURI = dockerResource.getURI().toString();
            commands.add(dockerImageURI.substring("docker:".length()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return commands;
    }
}

