/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandLineTokenizer {
    private final char[] buffer;
    private int pos;
    private static final char ESCAPE_CHAR = '\\';
    private final List<String> args = new ArrayList<String>();

    public CommandLineTokenizer(String value) {
        this.buffer = value.toCharArray();
        this.tokenize();
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    private void tokenize() {
        while (this.pos < this.buffer.length) {
            this.eatWhiteSpace();
            if (this.pos >= this.buffer.length) continue;
            this.eatArg();
        }
    }

    private void eatWhiteSpace() {
        while (this.pos < this.buffer.length && this.buffer[this.pos] == ' ') {
            ++this.pos;
        }
    }

    private void eatArg() {
        char endDelimiter = this.buffer[this.pos] == '\'' || this.buffer[this.pos] == '\"' ? this.buffer[this.pos++] : (char)' ';
        StringBuilder sb = new StringBuilder();
        while (this.pos < this.buffer.length && this.buffer[this.pos] != endDelimiter) {
            if (this.buffer[this.pos] == '\\') {
                sb.append(this.processCharacterEscapeCodes(endDelimiter));
                continue;
            }
            sb.append(this.buffer[this.pos++]);
        }
        if (this.pos == this.buffer.length && endDelimiter != ' ') {
            throw new IllegalStateException(String.format("Ran out of input in [%s], expected closing [%s]", new String(this.buffer), Character.valueOf(endDelimiter)));
        }
        if (endDelimiter != ' ' && this.buffer[this.pos] == endDelimiter) {
            ++this.pos;
        }
        this.args.add(sb.toString());
    }

    private char processCharacterEscapeCodes(char endDelimiter) {
        ++this.pos;
        if (this.pos >= this.buffer.length) {
            throw new IllegalStateException("Ran out of input in escape sequence");
        }
        if (this.buffer[this.pos] == '\\') {
            ++this.pos;
            return '\\';
        }
        if (this.buffer[this.pos] == endDelimiter) {
            ++this.pos;
            return endDelimiter;
        }
        return '\\';
    }
}

