/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.thin;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.thin.AbstractThinJarSupport;
import org.springframework.cloud.deployer.thin.InMemoryAppInstanceStatus;
import org.springframework.cloud.deployer.thin.ThinJarAppWrapper;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SocketUtils;

public class ThinJarAppDeployer
extends AbstractThinJarSupport
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";
    private static final int DEFAULT_SERVER_PORT = 8080;

    public ThinJarAppDeployer() {
        this("thin", new String[0]);
    }

    public ThinJarAppDeployer(String name, String ... profiles) {
        super(name, profiles);
    }

    @Override
    public String deploy(AppDeploymentRequest request) {
        String id = super.deploy(request);
        ThinJarAppWrapper wrapper = super.getWrapper(id);
        wrapper.status(AppStatus.of((String)id).with((AppInstanceStatus)new InMemoryAppInstanceStatus(wrapper)).build());
        return id;
    }

    @Override
    protected Map<String, String> getProperties(AppDeploymentRequest request) {
        int port;
        Map<String, String> properties = super.getProperties(request);
        boolean useDynamicPort = !properties.containsKey(SERVER_PORT_KEY);
        int n = port = useDynamicPort ? SocketUtils.findAvailableTcpPort((int)8080) : Integer.parseInt((String)request.getDefinition().getProperties().get(SERVER_PORT_KEY));
        if (useDynamicPort) {
            properties.put(SERVER_PORT_KEY, String.valueOf(port));
        }
        return properties;
    }

    public AppStatus status(String id) {
        return (AppStatus)super.getWrapper(id).status();
    }

    public void undeploy(String id) {
        super.cancel(id);
    }

    public Object getBean(String id, Class<?> type) {
        ThinJarAppWrapper wrapper = this.getWrapper(id);
        if (wrapper == null) {
            return null;
        }
        try {
            return this.getBean(wrapper, type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot extract bean of type: " + type, e);
        }
    }

    public Map<String, Object> getBeansOfType(String id, Class<?> type) {
        ThinJarAppWrapper wrapper = this.getWrapper(id);
        if (wrapper == null) {
            return Collections.emptyMap();
        }
        try {
            return this.getBeansOfType(wrapper, type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot extract beans of type: " + type, e);
        }
    }

    private Map<String, Object> getBeansOfType(ThinJarAppWrapper wrapper, Class<?> type) throws IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object app = this.findContext(wrapper);
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(app);
        invoker.setTargetMethod("getBeansOfType");
        invoker.setArguments(new Object[]{this.findType(app, type)});
        invoker.prepare();
        Map map = (Map)invoker.invoke();
        return map;
    }

    private Object getBean(ThinJarAppWrapper wrapper, Class<?> type) throws IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object app = this.findContext(wrapper);
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(app);
        invoker.setTargetMethod("getBean");
        invoker.setArguments(new Object[]{this.findType(app, type)});
        invoker.prepare();
        return invoker.invoke();
    }

    private Object findType(Object app, Class<?> type) {
        if (app.getClass().getClassLoader() == type.getClassLoader()) {
            return type;
        }
        return ClassUtils.resolveClassName((String)type.getName(), (ClassLoader)app.getClass().getClassLoader());
    }

    private Object findContext(ThinJarAppWrapper wrapper) {
        Object app = wrapper.getApp();
        Field field = ReflectionUtils.findField(app.getClass(), (String)"context");
        ReflectionUtils.makeAccessible((Field)field);
        app = ReflectionUtils.getField((Field)field, (Object)app);
        return app;
    }
}

