/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.adapter.aws.SpringFunctionInitializer;
import reactor.core.publisher.Flux;

public class SpringBootStreamHandler
extends SpringFunctionInitializer
implements RequestStreamHandler {
    @Autowired
    private ObjectMapper mapper;

    public SpringBootStreamHandler() {
    }

    public SpringBootStreamHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        this.initialize();
        Object value = this.convertStream(input);
        Publisher<?> flux = this.apply((Publisher<?>)this.extract(value));
        this.mapper.writeValue(output, this.result(value, flux));
    }

    private Object result(Object input, Publisher<?> flux) {
        ArrayList result = new ArrayList();
        for (Object value : Flux.from(flux).toIterable()) {
            result.add(value);
        }
        if (this.isSingleValue(input) && result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private boolean isSingleValue(Object input) {
        return !(input instanceof Collection);
    }

    private Flux<?> extract(Object input) {
        if (input instanceof Collection) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    private Object convertStream(InputStream input) {
        try {
            return this.mapper.readValue(input, this.getInputType());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert event", e);
        }
    }
}

