/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.LambdaEventSerializers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

final class AWSLambdaUtils {
    private static Log logger = LogFactory.getLog(AWSLambdaUtils.class);
    static final String AWS_API_GATEWAY = "aws-api-gateway";
    public static final String AWS_CONTEXT = "aws-context";

    private AWSLambdaUtils() {
    }

    public static Message<byte[]> generateMessage(byte[] payload, MessageHeaders headers, Type inputType, JsonMapper objectMapper) {
        return AWSLambdaUtils.generateMessage(payload, headers, inputType, objectMapper, null);
    }

    static boolean isSupportedAWSType(Type inputType) {
        String typeName = inputType.getTypeName();
        return typeName.equals("com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent") || typeName.equals("com.amazonaws.services.lambda.runtime.events.S3Event") || typeName.equals("com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent") || typeName.equals("com.amazonaws.services.lambda.runtime.events.SNSEvent") || typeName.equals("com.amazonaws.services.lambda.runtime.events.SQSEvent") || typeName.equals("com.amazonaws.services.lambda.runtime.events.APIGatewayCustomAuthorizerEvent") || typeName.equals("com.amazonaws.services.lambda.runtime.events.KinesisEvent");
    }

    public static Message<byte[]> generateMessage(byte[] payload, MessageHeaders headers, Type inputType, JsonMapper objectMapper, @Nullable Context awsContext) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Incoming JSON Event: " + new String(payload)));
        }
        if (FunctionTypeUtils.isMessage((Type)inputType)) {
            inputType = FunctionTypeUtils.getImmediateGenericType((Type)inputType, (int)0);
        }
        MessageBuilder messageBuilder = null;
        if (inputType != null && AWSLambdaUtils.isSupportedAWSType(inputType)) {
            PojoSerializer serializer = LambdaEventSerializers.serializerFor((Class)FunctionTypeUtils.getRawType((Type)inputType), (ClassLoader)Thread.currentThread().getContextClassLoader());
            Object event = serializer.fromJson((InputStream)new ByteArrayInputStream(payload));
            messageBuilder = MessageBuilder.withPayload((Object)event);
            if (event instanceof APIGatewayProxyRequestEvent || event instanceof APIGatewayV2HTTPEvent) {
                messageBuilder.setHeader(AWS_API_GATEWAY, (Object)true);
                logger.info((Object)"Incoming request is API Gateway");
            }
        } else {
            Object request;
            try {
                request = objectMapper.fromJson((Object)payload, Object.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            if (request instanceof Map) {
                logger.info((Object)("Incoming MAP: " + request));
                if (((Map)request).containsKey("httpMethod")) {
                    boolean mapInputType;
                    logger.info((Object)"Incoming request is API Gateway");
                    boolean bl = mapInputType = inputType instanceof ParameterizedType && ((Class)((ParameterizedType)inputType).getRawType()).isAssignableFrom(Map.class);
                    if (mapInputType) {
                        messageBuilder = MessageBuilder.withPayload((Object)request).setHeader("httpMethod", ((Map)request).get("httpMethod"));
                        messageBuilder.setHeader(AWS_API_GATEWAY, (Object)true);
                    } else {
                        messageBuilder = AWSLambdaUtils.createMessageBuilderForPOJOFunction(objectMapper, (Map)request);
                    }
                } else if (((Map)request).containsKey("routeKey") && ((Map)request).containsKey("version")) {
                    logger.info((Object)"Incoming request is API Gateway v2.0");
                    messageBuilder = AWSLambdaUtils.createMessageBuilderForPOJOFunction(objectMapper, (Map)request);
                }
                Object providedHeaders = ((Map)request).remove("headers");
                if (providedHeaders != null && providedHeaders instanceof Map) {
                    messageBuilder = MessageBuilder.withPayload((Object)request);
                    messageBuilder.removeHeader("headers");
                    messageBuilder.copyHeaders((Map)providedHeaders);
                }
            } else if (request instanceof Iterable) {
                messageBuilder = MessageBuilder.withPayload((Object)request);
            }
        }
        if (messageBuilder == null) {
            messageBuilder = MessageBuilder.withPayload((Object)payload);
        }
        if (awsContext != null) {
            messageBuilder.setHeader(AWS_CONTEXT, (Object)awsContext);
        }
        logger.info((Object)("Incoming request headers: " + headers));
        return messageBuilder.copyHeaders((Map)headers).build();
    }

    private static MessageBuilder createMessageBuilderForPOJOFunction(JsonMapper objectMapper, Map request) {
        Object body = request.remove("body");
        try {
            body = body instanceof String ? String.valueOf(body).getBytes(StandardCharsets.UTF_8) : objectMapper.toJson(body);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        logger.info((Object)("Body is " + body));
        MessageBuilder messageBuilder = MessageBuilder.withPayload(body).copyHeaders(request);
        messageBuilder.setHeader(AWS_API_GATEWAY, (Object)true);
        return messageBuilder;
    }

    private static byte[] extractPayload(Message<Object> msg, JsonMapper objectMapper) {
        if (msg.getPayload() instanceof byte[]) {
            return (byte[])msg.getPayload();
        }
        return objectMapper.toJson(msg.getPayload());
    }

    public static byte[] generateOutput(Message requestMessage, Message<?> responseMessage, JsonMapper objectMapper, Type functionOutputType) {
        byte[] responseBytes;
        String outputClassName;
        Class outputClass = FunctionTypeUtils.getRawType((Type)functionOutputType);
        if (outputClass != null && ((outputClassName = outputClass.getName()).equals("com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse") || outputClassName.equals("com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent") || outputClassName.equals("com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent") || outputClassName.equals("com.amazonaws.services.lambda.runtime.events.IamPolicyResponse"))) {
            return AWSLambdaUtils.extractPayload(responseMessage, objectMapper);
        }
        byte[] byArray = responseBytes = responseMessage == null ? "\"OK\"".getBytes() : AWSLambdaUtils.extractPayload(responseMessage, objectMapper);
        if (requestMessage.getHeaders().containsKey((Object)AWS_API_GATEWAY) && ((Boolean)requestMessage.getHeaders().get((Object)AWS_API_GATEWAY)).booleanValue()) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("isBase64Encoded", false);
            AtomicReference<MessageHeaders> headers = new AtomicReference<MessageHeaders>();
            int statusCode = HttpStatus.OK.value();
            if (responseMessage != null) {
                headers.set(responseMessage.getHeaders());
                statusCode = ((MessageHeaders)headers.get()).containsKey((Object)"statusCode") ? ((Integer)((MessageHeaders)headers.get()).get((Object)"statusCode")).intValue() : HttpStatus.OK.value();
            }
            response.put("statusCode", statusCode);
            if (AWSLambdaUtils.isRequestKinesis((Message<Object>)requestMessage)) {
                HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
                response.put("statusDescription", httpStatus.toString());
            }
            String body = responseMessage == null ? "\"OK\"" : new String(AWSLambdaUtils.extractPayload(responseMessage, objectMapper), StandardCharsets.UTF_8);
            response.put("body", body);
            if (responseMessage != null) {
                HashMap responseHeaders = new HashMap();
                ((MessageHeaders)headers.get()).keySet().forEach(key -> responseHeaders.put(key, ((MessageHeaders)headers.get()).get(key).toString()));
                response.put("headers", responseHeaders);
            }
            try {
                responseBytes = objectMapper.toJson(response);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to serialize AWS Lambda output", e);
            }
        }
        return responseBytes;
    }

    private static boolean isRequestKinesis(Message<Object> requestMessage) {
        return requestMessage.getHeaders().containsKey((Object)"Records");
    }
}

