/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.OutputBinding;
import java.util.Collection;
import java.util.function.Function;
import java.util.logging.Logger;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.AbstractSpringFunctionAdapterInitializer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AzureSpringBootRequestHandler<I, O>
extends AbstractSpringFunctionAdapterInitializer<ExecutionContext> {
    private static AzureSpringBootRequestHandler thisInitializer;
    private String functionName;
    private static final ExecutionContextDelegate EXECUTION_CTX_DELEGATE;

    public AzureSpringBootRequestHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public AzureSpringBootRequestHandler() {
    }

    public O handleRequest(ExecutionContext context) {
        return this.handleRequest(null, context);
    }

    public void close() {
        thisInitializer = null;
        super.close();
    }

    public O handleRequest(I input, ExecutionContext context) {
        AzureSpringBootRequestHandler.EXECUTION_CTX_DELEGATE.targetContext = context;
        String name = "";
        try {
            if (context != null) {
                name = context.getFunctionName();
                context.getLogger().info("Handler processing a request for: " + name);
            }
            if (thisInitializer == null || !AzureSpringBootRequestHandler.thisInitializer.functionName.equals(name)) {
                this.initialize(EXECUTION_CTX_DELEGATE);
                this.functionName = name;
                thisInitializer = this;
                return thisInitializer.handleRequest(input, context);
            }
            Flux<?> events = input == null ? Mono.empty() : this.extract(this.convertEvent(input));
            Publisher output = thisInitializer.apply((Publisher)events);
            Object result = this.result(input, output);
            if (context != null) {
                context.getLogger().fine("Handler processed a request for: " + name);
            }
            return (O)result;
        }
        catch (Throwable ex) {
            if (context != null) {
                context.getLogger().throwing(((Object)((Object)this)).getClass().getName(), "handle", ex);
            }
            throw (RuntimeException)ex;
        }
    }

    protected String doResolveName(Object targetContext) {
        return ((ExecutionContext)targetContext).getFunctionName();
    }

    public void handleOutput(I input, OutputBinding<O> binding, ExecutionContext context) {
        O result = this.handleRequest(input, context);
        binding.setValue(result);
    }

    protected Object convertEvent(I input) {
        return input;
    }

    protected Flux<?> extract(Object input) {
        if (!this.isSingleInput(this.getFunction(), input)) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    protected boolean isSingleInput(Function<?, ?> function, Object input) {
        if (!(input instanceof Collection)) {
            return true;
        }
        if (this.getInspector() != null) {
            return Collection.class.isAssignableFrom(this.getInspector().getInputType(function));
        }
        return ((Collection)input).size() <= 1;
    }

    protected boolean isSingleOutput(Function<?, ?> function, Object output) {
        if (!(output instanceof Collection)) {
            return true;
        }
        if (this.getInspector() != null) {
            return Collection.class.isAssignableFrom(this.getInspector().getOutputType(function));
        }
        return ((Collection)output).size() <= 1;
    }

    static {
        EXECUTION_CTX_DELEGATE = new ExecutionContextDelegate();
    }

    private static class ExecutionContextDelegate
    implements ExecutionContext {
        ExecutionContext targetContext;

        private ExecutionContextDelegate() {
        }

        public Logger getLogger() {
            if (this.targetContext == null || this.targetContext.getLogger() == null) {
                return Logger.getAnonymousLogger();
            }
            return this.targetContext.getLogger();
        }

        public String getInvocationId() {
            return this.targetContext.getInvocationId();
        }

        public String getFunctionName() {
            return this.targetContext.getFunctionName();
        }

        public String toString() {
            return "ExecutionContextDelegate over: " + this.targetContext;
        }
    }
}

