/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.gcp;

import com.google.cloud.functions.Context;
import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import com.google.cloud.functions.RawBackgroundFunction;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;

public class FunctionInvoker
implements HttpFunction,
RawBackgroundFunction {
    private static final Log log = LogFactory.getLog(FunctionInvoker.class);
    public static final String HTTP_STATUS_CODE = "statusCode";
    private String functionName = "";
    protected FunctionCatalog catalog;
    private SimpleFunctionRegistry.FunctionInvocationWrapper functionWrapped;
    private ConfigurableApplicationContext context;

    public FunctionInvoker() {
        this(FunctionClassUtils.getStartClass());
    }

    public FunctionInvoker(Class<?> configurationClass) {
        this.init(configurationClass);
    }

    private void init(Class<?> configurationClass) {
        if (!System.getenv().containsKey("spring.cloud.function.preferred-json-mapper")) {
            System.setProperty("spring.cloud.function.preferred-json-mapper", "gson");
        }
        Thread.currentThread().setContextClassLoader(FunctionInvoker.class.getClassLoader());
        log.info((Object)("Initializing: " + configurationClass));
        SpringApplication springApplication = this.springApplication(configurationClass);
        this.context = springApplication.run(new String[0]);
        this.catalog = (FunctionCatalog)this.context.getBean(FunctionCatalog.class);
        this.initFunctionConsumerOrSupplierFromCatalog();
    }

    private <I> Function<Message<I>, Message<byte[]>> lookupFunction() {
        Function function = (Function)this.catalog.lookup(this.functionName, new String[]{MimeTypeUtils.APPLICATION_JSON.toString()});
        Assert.notNull((Object)function, (String)("'function' with name '" + this.functionName + "' must not be null"));
        return function;
    }

    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        Message message;
        Function function = this.lookupFunction();
        Message<byte[]> result = function.apply(message = this.functionWrapped.getInputType() == Void.class || this.functionWrapped.getInputType() == null ? null : MessageBuilder.withPayload((Object)httpRequest.getReader()).copyHeaders(httpRequest.getHeaders()).build());
        if (result != null) {
            MessageHeaders headers = result.getHeaders();
            httpResponse.getWriter().write(new String((byte[])result.getPayload(), StandardCharsets.UTF_8));
            for (Map.Entry header : headers.entrySet()) {
                Object values = header.getValue();
                if (values instanceof Collection) {
                    String headerValue = ((Collection)values).stream().map(item -> item.toString()).collect(Collectors.joining(","));
                    httpResponse.appendHeader((String)header.getKey(), headerValue);
                    continue;
                }
                httpResponse.appendHeader((String)header.getKey(), header.getValue().toString());
            }
            httpRequest.getContentType().ifPresent(contentType -> httpResponse.setContentType(contentType));
            if (headers.containsKey((Object)HTTP_STATUS_CODE)) {
                if (headers.get((Object)HTTP_STATUS_CODE) instanceof Integer) {
                    httpResponse.setStatusCode(((Integer)headers.get((Object)HTTP_STATUS_CODE)).intValue());
                } else {
                    log.warn((Object)"The statusCode should be an Integer value");
                }
            }
        }
    }

    public void accept(String json, Context context) {
        Message message;
        Function function = this.lookupFunction();
        Message<byte[]> result = function.apply(message = this.functionWrapped.getInputType() == Void.class ? null : MessageBuilder.withPayload((Object)json).setHeader("gcf_context", (Object)context).build());
        if (result != null) {
            log.info((Object)("Dropping background function result: " + new String((byte[])result.getPayload())));
        }
    }

    private void initFunctionConsumerOrSupplierFromCatalog() {
        String name = this.resolveName(Function.class);
        this.functionWrapped = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.catalog.lookup(Function.class, name);
        if (this.functionWrapped != null) {
            this.functionName = name;
            return;
        }
        name = this.resolveName(Consumer.class);
        this.functionWrapped = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.catalog.lookup(Consumer.class, name);
        if (this.functionWrapped != null) {
            this.functionName = name;
            return;
        }
        name = this.resolveName(Supplier.class);
        this.functionWrapped = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.catalog.lookup(Supplier.class, name);
        if (this.functionWrapped != null) {
            this.functionName = name;
            return;
        }
        this.functionWrapped = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.catalog.lookup("functionRouter", new String[]{"application/json"});
        if (this.functionWrapped != null) {
            this.functionName = "functionRouter";
        }
        Assert.notNull((Object)this.functionWrapped, (String)"Couldn't resolve a handler function");
    }

    private String resolveName(Class<?> type) {
        if (System.getenv().containsKey("spring.cloud.function.definition")) {
            return System.getenv("spring.cloud.function.definition");
        }
        String functionName = this.context.getEnvironment().getProperty("function.name");
        if (functionName != null) {
            return functionName;
        }
        if (type.isAssignableFrom(Function.class)) {
            return "function";
        }
        if (type.isAssignableFrom(Consumer.class)) {
            return "consumer";
        }
        if (type.isAssignableFrom(Supplier.class)) {
            return "supplier";
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private SpringApplication springApplication(Class<?> configurationClass) {
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{configurationClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }
}

