/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.MethodMetadata;

@Configuration
@ConditionalOnClass(name={"kotlin.jvm.functions.Function1"})
class KotlinLambdaToFunctionAutoConfiguration {
    protected final Log logger = LogFactory.getLog(this.getClass());

    KotlinLambdaToFunctionAutoConfiguration() {
    }

    @Bean
    public BeanFactoryPostProcessor kotlinToFunctionTransformer() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                String[] beanDefinitionNames;
                for (String beanDefinitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
                    String returnTypeName;
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
                    Object source = beanDefinition.getSource();
                    if (!(source instanceof MethodMetadata) || !(returnTypeName = ((MethodMetadata)source).getReturnTypeName()).startsWith("kotlin.jvm.functions.Function")) continue;
                    FunctionType functionType = new FunctionType(FunctionContextUtils.findType((String)beanDefinitionName, (ConfigurableListableBeanFactory)beanFactory));
                    if (returnTypeName.equals("kotlin.jvm.functions.Function1")) {
                        if (Unit.class.isAssignableFrom(functionType.getOutputType())) {
                            KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanDefinitionName + " to java Consumer"));
                            this.register(beanDefinitionName, beanDefinition, KotlinConsumer.class, (BeanDefinitionRegistry)beanFactory);
                            continue;
                        }
                        KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanDefinitionName + " to java Function"));
                        this.register(beanDefinitionName, beanDefinition, KotlinFunction.class, (BeanDefinitionRegistry)beanFactory);
                        continue;
                    }
                    KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanDefinitionName + " to java Supplier"));
                    this.register(beanDefinitionName, beanDefinition, KotlinSupplier.class, (BeanDefinitionRegistry)beanFactory);
                }
            }

            private void register(String originalName, BeanDefinition originalDefinition, Class<?> clazz, BeanDefinitionRegistry registry) {
                RootBeanDefinition cbd = new RootBeanDefinition(clazz);
                ConstructorArgumentValues ca = new ConstructorArgumentValues();
                ca.addGenericArgumentValue((Object)originalDefinition);
                cbd.setConstructorArgumentValues(ca);
                registry.removeBeanDefinition(originalName);
                registry.registerBeanDefinition(originalName, (BeanDefinition)cbd);
            }
        };
    }

    private static class KotlinSupplier<O>
    implements Supplier<O>,
    Function0<O> {
        private final Function0<O> kotlinLambda;

        private KotlinSupplier(Function0<O> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        @Override
        public O get() {
            return this.invoke();
        }

        public O invoke() {
            return (O)this.kotlinLambda.invoke();
        }
    }

    private static class KotlinConsumer<I, U>
    implements Consumer<I>,
    Function1<I, U> {
        private final Function1<I, U> kotlinLambda;

        private KotlinConsumer(Function1<I, U> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        public U invoke(I i) {
            return (U)this.kotlinLambda.invoke(i);
        }

        @Override
        public void accept(I i) {
            this.kotlinLambda.invoke(i);
        }
    }

    private static class KotlinFunction<I, O>
    implements Function<I, O>,
    Function1<I, O> {
        private final Function1<I, O> kotlinLambda;

        private KotlinFunction(Function1<I, O> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        @Override
        public O apply(I i) {
            return (O)this.kotlinLambda.invoke(i);
        }

        public O invoke(I i) {
            return this.apply(i);
        }
    }
}

