/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Objects;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestSizeGatewayFilterFactory
extends AbstractGatewayFilterFactory<RequestSizeConfig> {
    private static String PREFIX = "kMGTPE";
    private static String ERROR = "Request size is larger than permissible limit. Request size is %s where permissible limit is %s";

    public RequestSizeGatewayFilterFactory() {
        super(RequestSizeConfig.class);
    }

    private static String getErrorMessage(Long currentRequestSize, Long maxSize) {
        return String.format(ERROR, RequestSizeGatewayFilterFactory.getReadableByteCount(currentRequestSize), RequestSizeGatewayFilterFactory.getReadableByteCount(maxSize));
    }

    private static String getReadableByteCount(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = Character.toString(PREFIX.charAt(exp - 1));
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    @Override
    public GatewayFilter apply(final RequestSizeConfig requestSizeConfig) {
        requestSizeConfig.validate();
        return new GatewayFilter(){
            final /* synthetic */ RequestSizeGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                Long currentRequestSize;
                ServerHttpRequest request = exchange.getRequest();
                String contentLength = request.getHeaders().getFirst("content-length");
                if (!ObjectUtils.isEmpty((Object)contentLength) && (currentRequestSize = Long.valueOf(contentLength)) > requestSizeConfig.getMaxSize().toBytes()) {
                    exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.CONTENT_TOO_LARGE);
                    if (!exchange.getResponse().isCommitted()) {
                        exchange.getResponse().getHeaders().add("errorMessage", RequestSizeGatewayFilterFactory.getErrorMessage(currentRequestSize, requestSizeConfig.getMaxSize().toBytes()));
                    }
                    return exchange.getResponse().setComplete();
                }
                return chain.filter(exchange);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("max", (Object)requestSizeConfig.getMaxSize()).toString();
            }
        };
    }

    public static class RequestSizeConfig {
        private DataSize maxSize = DataSize.ofBytes((long)5000000L);

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public RequestSizeConfig setMaxSize(DataSize maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public void validate() {
            Objects.requireNonNull(this.maxSize, "maxSize may not be null");
            Assert.isTrue((this.maxSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxSize must be greater than 0");
        }
    }
}

