/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@ConditionalOnProperty(value={"spring.cloud.gateway.server.webflux.filter.local-response-cache.enabled"}, havingValue="true")
public class LocalResponseCacheGatewayFilterFactory
extends AbstractGatewayFilterFactory<RouteCacheConfiguration> {
    public static final String LOCAL_RESPONSE_CACHE_FILTER_APPLIED = "LocalResponseCacheGatewayFilter-Applied";
    private final ResponseCacheManagerFactory cacheManagerFactory;
    private final Duration defaultTimeToLive;
    private final DataSize defaultSize;
    private final LocalResponseCacheProperties.RequestOptions requestOptions;
    private final CaffeineCacheManager caffeineCacheManager;

    public LocalResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory cacheManagerFactory, Duration defaultTimeToLive, DataSize defaultSize, LocalResponseCacheProperties.RequestOptions requestOptions) {
        this(cacheManagerFactory, defaultTimeToLive, defaultSize, requestOptions, new CaffeineCacheManager());
    }

    public LocalResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory cacheManagerFactory, Duration defaultTimeToLive, DataSize defaultSize, LocalResponseCacheProperties.RequestOptions requestOptions, CaffeineCacheManager caffeineCacheManager) {
        super(RouteCacheConfiguration.class);
        this.cacheManagerFactory = cacheManagerFactory;
        this.defaultTimeToLive = defaultTimeToLive;
        this.defaultSize = defaultSize;
        this.requestOptions = requestOptions;
        this.caffeineCacheManager = caffeineCacheManager;
    }

    @Override
    public GatewayFilter apply(RouteCacheConfiguration config) {
        LocalResponseCacheProperties cacheProperties = this.mapRouteCacheConfig(config);
        Caffeine caffeine = LocalResponseCacheUtils.createCaffeine(cacheProperties);
        String cacheName = config.getRouteId() + "-cache";
        this.caffeineCacheManager.registerCustomCache(cacheName, caffeine.build());
        Cache routeCache = this.caffeineCacheManager.getCache(cacheName);
        Objects.requireNonNull(routeCache, "Cache " + cacheName + " not found");
        return new ResponseCacheGatewayFilter(this.cacheManagerFactory.create(routeCache, cacheProperties.getTimeToLive(), this.requestOptions));
    }

    private LocalResponseCacheProperties mapRouteCacheConfig(RouteCacheConfiguration config) {
        Duration timeToLive = config.getTimeToLive() != null ? config.getTimeToLive() : this.defaultTimeToLive;
        DataSize size = config.getSize() != null ? config.getSize() : this.defaultSize;
        LocalResponseCacheProperties responseCacheProperties = new LocalResponseCacheProperties();
        responseCacheProperties.setTimeToLive(timeToLive);
        responseCacheProperties.setSize(size);
        return responseCacheProperties;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return List.of("timeToLive", "size");
    }

    @Validated
    public static class RouteCacheConfiguration
    implements HasRouteId {
        private @Nullable DataSize size;
        private @Nullable Duration timeToLive;
        private @Nullable String routeId;

        public @Nullable DataSize getSize() {
            return this.size;
        }

        public RouteCacheConfiguration setSize(@Nullable DataSize size) {
            this.size = size;
            return this;
        }

        public @Nullable Duration getTimeToLive() {
            return this.timeToLive;
        }

        public RouteCacheConfiguration setTimeToLive(@Nullable Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public @Nullable String getRouteId() {
            return this.routeId;
        }
    }
}

