/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.server.HttpServerResponse;

public interface TrailerHeadersFilter {
    public static Mono<HttpHeaders> filter(@Nullable List<HttpHeadersFilter> filters, ServerWebExchange exchange, @Nullable HttpClientResponse response) {
        if (response == null) {
            return Mono.empty();
        }
        Mono headers = response.trailerHeaders().map(input -> {
            HttpHeaders httpHeaders = new HttpHeaders();
            input.forEach(entry -> httpHeaders.add((String)entry.getKey(), (String)entry.getValue()));
            return httpHeaders;
        });
        return TrailerHeadersFilter.filter(filters, (Mono<HttpHeaders>)headers, exchange);
    }

    private static Mono<HttpHeaders> filter(@Nullable List<HttpHeadersFilter> filters, Mono<HttpHeaders> input, ServerWebExchange exchange) {
        Mono filtered = input;
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                HttpHeadersFilter httpHeadersFilter = filters.get(i);
                if (!(httpHeadersFilter instanceof TrailerHeadersFilter)) continue;
                TrailerHeadersFilter filter = (TrailerHeadersFilter)((Object)httpHeadersFilter);
                filtered = filtered.map(headers -> filter.trailers((HttpHeaders)headers, exchange));
            }
        }
        return filtered.doOnSuccess(headers -> {
            if (headers == null || headers.isEmpty()) {
                return;
            }
            ServerHttpResponse response = exchange.getResponse();
            while (response instanceof ServerHttpResponseDecorator) {
                response = ((ServerHttpResponseDecorator)response).getDelegate();
            }
            if (response instanceof AbstractServerHttpResponse) {
                ((HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse()).trailerHeaders(h -> headers.forEach((key, values) -> {
                    for (String value : values) {
                        h.add(key, (Object)value);
                    }
                }));
            }
        });
    }

    public HttpHeaders trailers(@Nullable HttpHeaders var1, ServerWebExchange var2);
}

