/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayDocumentedObservation;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayObservationConvention;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;

public class DefaultGatewayObservationConvention
implements GatewayObservationConvention {
    public static final GatewayObservationConvention INSTANCE = new DefaultGatewayObservationConvention();

    public KeyValues getLowCardinalityKeyValues(GatewayContext context) {
        ServerHttpResponse response;
        KeyValues keyValues = KeyValues.empty();
        if (context.getCarrier() == null) {
            return keyValues;
        }
        Route route = (Route)context.getServerWebExchange().getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        if (route != null) {
            keyValues = keyValues.and(new KeyValue[]{GatewayDocumentedObservation.LowCardinalityKeys.ROUTE_URI.withValue(route.getUri().toString()), GatewayDocumentedObservation.LowCardinalityKeys.METHOD.withValue(context.getRequest().getMethod().name())}).and(new KeyValue[]{GatewayDocumentedObservation.LowCardinalityKeys.ROUTE_ID.withValue(route.getId())});
        }
        keyValues = (response = (ServerHttpResponse)context.getResponse()) != null && response.getStatusCode() != null ? keyValues.and(new KeyValue[]{GatewayDocumentedObservation.LowCardinalityKeys.STATUS.withValue(String.valueOf(response.getStatusCode().value()))}) : keyValues.and(new KeyValue[]{GatewayDocumentedObservation.LowCardinalityKeys.STATUS.withValue("UNKNOWN")});
        return keyValues;
    }

    public KeyValues getHighCardinalityKeyValues(GatewayContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{GatewayDocumentedObservation.HighCardinalityKeys.URI.withValue(context.getRequest().getURI().toString())});
    }

    public String getName() {
        return "http.client.requests";
    }

    public @Nullable String getContextualName(GatewayContext context) {
        if (context.getRequest() == null) {
            return null;
        }
        return "HTTP " + String.valueOf(context.getRequest().getMethod());
    }
}

