/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveValueOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Repository
public class RedisRouteDefinitionRepository
implements RouteDefinitionRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRouteDefinitionRepository.class);
    private static final String ROUTEDEFINITION_REDIS_KEY_PREFIX_QUERY = "routedefinition_";
    private ReactiveRedisTemplate<String, RouteDefinition> reactiveRedisTemplate;
    private ReactiveValueOperations<String, RouteDefinition> routeDefinitionReactiveValueOperations;

    public RedisRouteDefinitionRepository(ReactiveRedisTemplate<String, RouteDefinition> reactiveRedisTemplate) {
        this.reactiveRedisTemplate = reactiveRedisTemplate;
        this.routeDefinitionReactiveValueOperations = reactiveRedisTemplate.opsForValue();
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        return this.reactiveRedisTemplate.scan(ScanOptions.scanOptions().match(this.createKey("*")).build()).flatMap(key -> this.reactiveRedisTemplate.opsForValue().get(key)).onErrorContinue((throwable, routeDefinition) -> {
            if (log.isErrorEnabled()) {
                log.error("get routes from redis error cause : {}", (Object)throwable.toString(), throwable);
            }
        });
    }

    @Override
    public Mono<Void> save(Mono<RouteDefinition> route) {
        return route.flatMap(routeDefinition -> {
            Objects.requireNonNull(routeDefinition.getId(), "id may not be null");
            return this.routeDefinitionReactiveValueOperations.set((Object)this.createKey(routeDefinition.getId()), routeDefinition).flatMap(success -> {
                if (success.booleanValue()) {
                    return Mono.empty();
                }
                return Mono.defer(() -> Mono.error((Throwable)new RuntimeException(String.format("Could not add route to redis repository: %s", routeDefinition))));
            });
        });
    }

    @Override
    public Mono<Void> delete(Mono<String> routeId) {
        return routeId.flatMap(id -> this.routeDefinitionReactiveValueOperations.delete((Object)this.createKey((String)id)).flatMap(success -> {
            if (success.booleanValue()) {
                return Mono.empty();
            }
            return Mono.defer(() -> Mono.error((Throwable)((Object)new NotFoundException(String.format("Could not remove route from redis repository with id: %s", routeId)))));
        }));
    }

    private String createKey(String routeId) {
        return ROUTEDEFINITION_REDIS_KEY_PREFIX_QUERY + routeId;
    }
}

