/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public abstract class AbstractProxyExchange
implements ProxyExchange {
    private final GatewayMvcProperties properties;

    protected AbstractProxyExchange(GatewayMvcProperties properties) {
        this.properties = properties;
    }

    protected int copyResponseBody(ClientHttpResponse clientResponse, InputStream inputStream, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(clientResponse, "No ClientResponse specified");
        Objects.requireNonNull(inputStream, "No InputStream specified");
        Objects.requireNonNull(outputStream, "No OutputStream specified");
        int transferredBytes = this.properties.getStreamingMediaTypes().contains(clientResponse.getHeaders().getContentType()) ? this.copyResponseBodyWithFlushing(inputStream, outputStream) : StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return transferredBytes;
    }

    private int copyResponseBodyWithFlushing(InputStream inputStream, OutputStream outputStream) throws IOException {
        int readBytes;
        int totalReadBytes = 0;
        byte[] buffer = new byte[this.properties.getStreamingBufferSize()];
        while ((readBytes = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, readBytes);
            outputStream.flush();
            if (totalReadBytes >= Integer.MAX_VALUE) continue;
            try {
                totalReadBytes = Math.addExact(totalReadBytes, readBytes);
            }
            catch (ArithmeticException e) {
                totalReadBytes = Integer.MAX_VALUE;
            }
        }
        outputStream.flush();
        return totalReadBytes;
    }
}

