/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.server.mvc.common.Configurable;
import org.springframework.cloud.gateway.server.mvc.common.Shortcut;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameters;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NormalizedOperationMethod
implements OperationMethod {
    private final OperationMethod delegate;
    private final Map<String, Object> normalizedArgs;

    public NormalizedOperationMethod(OperationMethod delegate, Map<String, Object> args) {
        this.delegate = delegate;
        this.normalizedArgs = this.normalizeArgs(args);
    }

    @Override
    public Method getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public boolean isConfigurable() {
        MergedAnnotation configurable = MergedAnnotations.from((AnnotatedElement)this.delegate.getMethod()).get(Configurable.class);
        return configurable.isPresent() && this.delegate.getParameters().getParameterCount() == 1;
    }

    @Override
    public OperationParameters getParameters() {
        return this.delegate.getParameters();
    }

    public Map<String, Object> getNormalizedArgs() {
        return this.normalizedArgs;
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Map<String, Object> normalizeArgs(Map<String, Object> operationArgs) {
        MergedAnnotation shortcutMergedAnnotation;
        if (NormalizedOperationMethod.hasGeneratedKey(operationArgs) && (shortcutMergedAnnotation = MergedAnnotations.from((AnnotatedElement)this.delegate.getMethod()).get(Shortcut.class)).isPresent()) {
            Shortcut shortcut = (Shortcut)shortcutMergedAnnotation.synthesize();
            String[] fieldOrder = this.getFieldOrder(shortcut);
            return switch (shortcut.type()) {
                case Shortcut.Type.DEFAULT -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int entryIdx = 0;
                    for (Map.Entry<String, Object> entry : operationArgs.entrySet()) {
                        String key = NormalizedOperationMethod.normalizeKey(entry.getKey(), entryIdx, operationArgs, fieldOrder);
                        Object value = entry.getValue();
                        map.put(key, value);
                        ++entryIdx;
                    }
                    yield map;
                }
                case Shortcut.Type.LIST -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    Assert.isTrue((fieldOrder != null && fieldOrder.length == 1 ? 1 : 0) != 0, (String)"Shortcut Configuration Type GATHER_LIST must have shortcutFieldOrder of size 1");
                    String fieldName = fieldOrder[0];
                    map.put(fieldName, StringUtils.collectionToCommaDelimitedString(operationArgs.values()));
                    yield map;
                }
                default -> throw new IllegalArgumentException("Unknown Shortcut type " + String.valueOf((Object)shortcut.type()));
            };
        }
        return operationArgs;
    }

    private String[] getFieldOrder(Shortcut shortcut) {
        String[] fieldOrder = shortcut.fieldOrder();
        if (fieldOrder.length == 0) {
            List<String> paramNames = this.getParameters().stream().map(OperationParameter::getName).toList();
            fieldOrder = paramNames.toArray(new String[0]);
        }
        return fieldOrder;
    }

    private static boolean hasGeneratedKey(Map<String, Object> operationArgs) {
        return operationArgs.keySet().stream().anyMatch(key -> key.startsWith("_genkey_"));
    }

    static String normalizeKey(String key, int entryIdx, Map<String, Object> args, String[] fieldOrder) {
        if (key.startsWith("_genkey_") && fieldOrder.length > 0 && entryIdx < args.size() && entryIdx < fieldOrder.length) {
            key = fieldOrder[entryIdx];
        }
        return key;
    }
}

