/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.gateway.server.mvc.GatewayMvcClassPathWarningAutoConfiguration;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.handler.FunctionHandlerHeaderUtils;
import org.springframework.cloud.gateway.server.mvc.handler.FunctionHandlerRequestProcessingHelper;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchangeHandlerFunction;
import org.springframework.cloud.stream.function.StreamOperations;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class HandlerFunctions {
    private static final Log log = LogFactory.getLog(GatewayMvcClassPathWarningAutoConfiguration.class);

    private HandlerFunctions() {
    }

    public static HandlerFunction<ServerResponse> fn(String functionName) {
        Assert.hasText((String)functionName, (String)"'functionName' must not be empty");
        return request -> {
            SimpleFunctionRegistry.FunctionInvocationWrapper function;
            FunctionCatalog functionCatalog = (FunctionCatalog)MvcUtils.getApplicationContext(request).getBean(FunctionCatalog.class);
            String expandedFunctionName = MvcUtils.expand(request, functionName);
            String body = null;
            if (expandedFunctionName.contains("/")) {
                String[] functionBodySplit = expandedFunctionName.split("/");
                function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionBodySplit[0], (String[])request.headers().accept().stream().map(MimeType::toString).toArray(String[]::new));
                if (function != null && function.isSupplier()) {
                    log.warn((Object)("Supplier must not have any arguments. Supplier: '" + function.getFunctionDefinition() + "' has '" + functionBodySplit[1] + "' as an argument which is ignored."));
                }
                body = functionBodySplit[1];
            } else {
                function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(expandedFunctionName, (String[])request.headers().accept().stream().map(MimeType::toString).toArray(String[]::new));
            }
            HashMap<String, String> additionalRequestHeaders = new HashMap<String, String>();
            if (function == null) {
                additionalRequestHeaders.put("spring.cloud.function.definition", expandedFunctionName);
                function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup("functionRouter", (String[])request.headers().accept().stream().map(MimeType::toString).toArray(String[]::new));
            }
            if (function != null) {
                if (body == null) {
                    body = function.isSupplier() ? null : request.body(function.getRawInputType());
                }
                return FunctionHandlerRequestProcessingHelper.processRequest(request, function, body, false, Collections.emptyList(), Collections.emptyList(), additionalRequestHeaders);
            }
            return ServerResponse.notFound().build();
        };
    }

    public static HandlerFunction<ServerResponse> stream(String bindingName) {
        Assert.hasText((String)bindingName, (String)"'bindingName' must not be empty");
        return request -> {
            MessageHeaders messageHeaders;
            byte[] body;
            String expandedBindingName = MvcUtils.expand(request, bindingName);
            StreamOperations streamOps = (StreamOperations)MvcUtils.getApplicationContext(request).getBean(StreamOperations.class);
            boolean send = streamOps.send(expandedBindingName, (Object)MessageBuilder.createMessage((Object)(body = (byte[])request.body(byte[].class)), (MessageHeaders)(messageHeaders = FunctionHandlerHeaderUtils.fromHttp(FunctionHandlerHeaderUtils.sanitize(request.headers().asHttpHeaders())))));
            if (send) {
                return ServerResponse.accepted().build();
            }
            return ServerResponse.badRequest().build();
        };
    }

    public static HandlerFunction<ServerResponse> forward(RouteProperties routeProperties) {
        Objects.requireNonNull(routeProperties.getUri(), "routeProperties uri must not be null");
        return HandlerFunctions.forward(routeProperties.getUri().getPath());
    }

    public static HandlerFunction<ServerResponse> forward(String path) {
        return request -> GatewayServerResponse.ok().build((httpServletRequest, httpServletResponse) -> {
            try {
                String expandedFallback = MvcUtils.expand(request, path);
                request.servletRequest().getServletContext().getRequestDispatcher(expandedFallback).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return null;
            }
            catch (ServletException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static HandlerFunction<ServerResponse> https() {
        return HandlerFunctions.http();
    }

    public static HandlerFunction<ServerResponse> http() {
        return new LookupProxyExchangeHandlerFunction();
    }

    public static HandlerFunction<ServerResponse> no() {
        return HandlerFunctions.http();
    }

    static class LookupProxyExchangeHandlerFunction
    implements HandlerFunction<ServerResponse> {
        private AtomicReference<@Nullable ProxyExchangeHandlerFunction> proxyExchangeHandlerFunction = new AtomicReference();

        LookupProxyExchangeHandlerFunction() {
        }

        public ServerResponse handle(ServerRequest serverRequest) {
            ProxyExchangeHandlerFunction proxyFunction = this.proxyExchangeHandlerFunction.updateAndGet(function -> {
                if (function == null) {
                    return LookupProxyExchangeHandlerFunction.lookup(serverRequest);
                }
                return function;
            });
            Objects.requireNonNull(proxyFunction, "No ProxyExchangeHandlerFunction found");
            return proxyFunction.handle(serverRequest);
        }

        private static ProxyExchangeHandlerFunction lookup(ServerRequest request) {
            return (ProxyExchangeHandlerFunction)MvcUtils.getApplicationContext(request).getBean(ProxyExchangeHandlerFunction.class);
        }

        public String toString() {
            ProxyExchangeHandlerFunction handlerFunction = this.proxyExchangeHandlerFunction.get();
            if (handlerFunction != null) {
                return handlerFunction.toString();
            }
            return ProxyExchangeHandlerFunction.class.getSimpleName();
        }
    }
}

