/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

public class NotFoundException
extends ResponseStatusException {
    public NotFoundException(String message) {
        this(HttpStatus.SERVICE_UNAVAILABLE, message);
    }

    public NotFoundException(String message, Throwable cause) {
        this(HttpStatus.SERVICE_UNAVAILABLE, message, cause);
    }

    private NotFoundException(HttpStatus httpStatus, String message) {
        super(httpStatus, message);
    }

    private NotFoundException(HttpStatus httpStatus, String message, Throwable cause) {
        super(httpStatus, message, cause);
    }

    public static NotFoundException create(boolean with404, String message) {
        HttpStatus httpStatus = with404 ? HttpStatus.NOT_FOUND : HttpStatus.SERVICE_UNAVAILABLE;
        return new NotFoundException(httpStatus, message);
    }

    public static NotFoundException create(boolean with404, String message, Throwable cause) {
        HttpStatus httpStatus = with404 ? HttpStatus.NOT_FOUND : HttpStatus.SERVICE_UNAVAILABLE;
        return new NotFoundException(httpStatus, message, cause);
    }
}

