/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SpringCloudCircuitBreakerFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String NAME = "CircuitBreaker";
    private ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory;
    private ReactiveCircuitBreaker cb;
    private final ObjectProvider<DispatcherHandler> dispatcherHandlerProvider;
    private volatile DispatcherHandler dispatcherHandler;

    public SpringCloudCircuitBreakerFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider) {
        super(Config.class);
        this.reactiveCircuitBreakerFactory = reactiveCircuitBreakerFactory;
        this.dispatcherHandlerProvider = dispatcherHandlerProvider;
    }

    private DispatcherHandler getDispatcherHandler() {
        if (this.dispatcherHandler == null) {
            this.dispatcherHandler = (DispatcherHandler)this.dispatcherHandlerProvider.getIfAvailable();
        }
        return this.dispatcherHandler;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("name");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final ReactiveCircuitBreaker cb = this.reactiveCircuitBreakerFactory.create(config.getId());
        final Set statuses = config.getStatusCodes().stream().map(HttpStatusHolder::parse).filter(statusHolder -> statusHolder.getHttpStatus() != null).map(HttpStatusHolder::getHttpStatus).collect(Collectors.toSet());
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return cb.run(chain.filter(exchange).doOnSuccess(v -> {
                    if (statuses.contains(exchange.getResponse().getStatusCode())) {
                        HttpStatus status = exchange.getResponse().getStatusCode();
                        throw new CircuitBreakerStatusCodeException(status);
                    }
                }), t -> {
                    if (config.getFallbackUri() == null) {
                        return Mono.error((Throwable)t);
                    }
                    exchange.getResponse().setStatusCode(null);
                    URI uri = exchange.getRequest().getURI();
                    boolean encoded = ServerWebExchangeUtils.containsEncodedParts(uri);
                    URI requestUrl = UriComponentsBuilder.fromUri((URI)uri).host(null).port(null).uri(config.getFallbackUri()).scheme(null).build(encoded).toUri();
                    exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
                    SpringCloudCircuitBreakerFilterFactory.this.addExceptionDetails(t, exchange);
                    ServerWebExchangeUtils.reset(exchange);
                    ServerHttpRequest request = exchange.getRequest().mutate().uri(requestUrl).build();
                    return ServerWebExchangeUtils.handle(SpringCloudCircuitBreakerFilterFactory.this.getDispatcherHandler(), exchange.mutate().request(request).build());
                }).onErrorResume(t -> SpringCloudCircuitBreakerFilterFactory.this.handleErrorWithoutFallback((Throwable)t, config.isResumeWithoutError()));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SpringCloudCircuitBreakerFilterFactory.this).append("name", (Object)config.getName()).append("fallback", (Object)config.fallbackUri).toString();
            }
        };
    }

    protected abstract Mono<Void> handleErrorWithoutFallback(Throwable var1, boolean var2);

    private void addExceptionDetails(Throwable t, ServerWebExchange exchange) {
        Optional.ofNullable(t).ifPresent(exception -> exchange.getAttributes().put(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR, exception));
    }

    @Override
    public String name() {
        return NAME;
    }

    public class CircuitBreakerStatusCodeException
    extends HttpStatusCodeException {
        public CircuitBreakerStatusCodeException(HttpStatus statusCode) {
            super(statusCode);
        }
    }

    public static class Config
    implements HasRouteId {
        private String name;
        private URI fallbackUri;
        private String routeId;
        private Set<String> statusCodes = new HashSet<String>();
        private boolean resumeWithoutError = false;

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }

        public URI getFallbackUri() {
            return this.fallbackUri;
        }

        public Config setFallbackUri(URI fallbackUri) {
            this.fallbackUri = fallbackUri;
            return this;
        }

        public Config setFallbackUri(String fallbackUri) {
            return this.setFallbackUri(URI.create(fallbackUri));
        }

        public String getName() {
            return this.name;
        }

        public Config setName(String name) {
            this.name = name;
            return this;
        }

        public String getId() {
            if (StringUtils.isEmpty((Object)this.name) && !StringUtils.isEmpty((Object)this.routeId)) {
                return this.routeId;
            }
            return this.name;
        }

        public Set<String> getStatusCodes() {
            return this.statusCodes;
        }

        public Config setStatusCodes(Set<String> statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public Config addStatusCode(String statusCode) {
            this.statusCodes.add(statusCode);
            return this;
        }

        public boolean isResumeWithoutError() {
            return this.resumeWithoutError;
        }

        public void setResumeWithoutError(boolean resumeWithoutError) {
            this.resumeWithoutError = resumeWithoutError;
        }
    }
}

