/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

@ConfigurationProperties(value="spring.cloud.gateway.filter.remove-hop-by-hop")
public class RemoveHopByHopHeadersFilter
implements HttpHeadersFilter,
Ordered {
    public static final Set<String> HEADERS_REMOVED_ON_REQUEST = new HashSet<String>(Arrays.asList("connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "x-application-context", "upgrade"));
    private int order = 0x7FFFFFFE;
    private Set<String> headers = HEADERS_REMOVED_ON_REQUEST;

    public Set<String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Set<String> headers) {
        this.headers = headers;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        HttpHeaders filtered = new HttpHeaders();
        for (Map.Entry entry : input.entrySet()) {
            if (this.headers.contains(((String)entry.getKey()).toLowerCase())) continue;
            filtered.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        return filtered;
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST) || type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

