/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import io.netty.buffer.Unpooled;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerWebExchangeUtils {
    private static final Log log = LogFactory.getLog(ServerWebExchangeUtils.class);
    public static final String PRESERVE_HOST_HEADER_ATTRIBUTE = ServerWebExchangeUtils.qualify("preserveHostHeader");
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = ServerWebExchangeUtils.qualify("uriTemplateVariables");
    public static final String CLIENT_RESPONSE_ATTR = ServerWebExchangeUtils.qualify("gatewayClientResponse");
    public static final String CLIENT_RESPONSE_CONN_ATTR = ServerWebExchangeUtils.qualify("gatewayClientResponseConnection");
    public static final String CLIENT_RESPONSE_HEADER_NAMES = ServerWebExchangeUtils.qualify("gatewayClientResponseHeaderNames");
    public static final String GATEWAY_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayRoute");
    public static final String GATEWAY_REACTOR_CONTEXT_ATTR = ServerWebExchangeUtils.qualify("gatewayReactorContext");
    public static final String GATEWAY_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayRequestUrl");
    public static final String GATEWAY_ORIGINAL_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayOriginalRequestUrl");
    public static final String GATEWAY_HANDLER_MAPPER_ATTR = ServerWebExchangeUtils.qualify("gatewayHandlerMapper");
    public static final String GATEWAY_SCHEME_PREFIX_ATTR = ServerWebExchangeUtils.qualify("gatewaySchemePrefix");
    public static final String GATEWAY_PREDICATE_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicateRouteAttr");
    public static final String GATEWAY_PREDICATE_MATCHED_PATH_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicateMatchedPathAttr");
    public static final String GATEWAY_PREDICATE_MATCHED_PATH_ROUTE_ID_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicateMatchedPathRouteIdAttr");
    public static final String GATEWAY_PREDICATE_PATH_CONTAINER_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicatePathContainer");
    public static final String WEIGHT_ATTR = ServerWebExchangeUtils.qualify("routeWeight");
    public static final String ORIGINAL_RESPONSE_CONTENT_TYPE_ATTR = "original_response_content_type";
    public static final String CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR = ServerWebExchangeUtils.qualify("circuitBreakerExecutionException");
    public static final String GATEWAY_ALREADY_ROUTED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyRouted");
    public static final String GATEWAY_ALREADY_PREFIXED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyPrefixed");
    public static final String CACHED_SERVER_HTTP_REQUEST_DECORATOR_ATTR = "cachedServerHttpRequestDecorator";
    public static final String CACHED_REQUEST_BODY_ATTR = "cachedRequestBody";
    public static final String GATEWAY_LOADBALANCER_RESPONSE_ATTR = ServerWebExchangeUtils.qualify("gatewayLoadBalancerResponse");
    public static final String GATEWAY_OBSERVATION_ATTR = ServerWebExchangeUtils.qualify("gateway.observation");
    private static final byte[] EMPTY_BYTES = new byte[0];

    private ServerWebExchangeUtils() {
        throw new AssertionError((Object)"Must not instantiate utility class.");
    }

    private static String qualify(String attr) {
        return ServerWebExchangeUtils.class.getName() + "." + attr;
    }

    public static void setAlreadyRouted(ServerWebExchange exchange) {
        exchange.getAttributes().put(GATEWAY_ALREADY_ROUTED_ATTR, true);
    }

    public static void removeAlreadyRouted(ServerWebExchange exchange) {
        exchange.getAttributes().remove(GATEWAY_ALREADY_ROUTED_ATTR);
    }

    public static boolean isAlreadyRouted(ServerWebExchange exchange) {
        return (Boolean)exchange.getAttributeOrDefault(GATEWAY_ALREADY_ROUTED_ATTR, (Object)false);
    }

    public static boolean setResponseStatus(ServerWebExchange exchange, HttpStatus httpStatus) {
        boolean response = exchange.getResponse().setStatusCode((HttpStatusCode)httpStatus);
        if (!response && log.isWarnEnabled()) {
            log.warn((Object)("Unable to set status code to " + httpStatus + ". Response already committed."));
        }
        return response;
    }

    public static void reset(ServerWebExchange exchange) {
        Set addedHeaders = (Set)exchange.getAttributeOrDefault(CLIENT_RESPONSE_HEADER_NAMES, Collections.emptySet());
        addedHeaders.forEach(header -> exchange.getResponse().getHeaders().remove(header));
        ServerWebExchangeUtils.removeAlreadyRouted(exchange);
    }

    public static boolean setResponseStatus(ServerWebExchange exchange, HttpStatusHolder statusHolder) {
        if (exchange.getResponse().isCommitted()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting response status to " + statusHolder));
        }
        if (statusHolder.getHttpStatus() != null) {
            return ServerWebExchangeUtils.setResponseStatus(exchange, statusHolder.getHttpStatus());
        }
        if (statusHolder.getStatus() != null && exchange.getResponse() instanceof AbstractServerHttpResponse) {
            ((AbstractServerHttpResponse)exchange.getResponse()).setRawStatusCode(statusHolder.getStatus());
            return true;
        }
        return false;
    }

    public static boolean containsEncodedParts(URI uri) {
        boolean encoded;
        boolean bl = encoded = uri.getRawQuery() != null && uri.getRawQuery().contains("%") || uri.getRawPath() != null && uri.getRawPath().contains("%");
        if (encoded) {
            try {
                UriComponentsBuilder.fromUri((URI)uri).build(true);
                return true;
            }
            catch (IllegalArgumentException ignored) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Error in containsEncodedParts", (Throwable)ignored);
                }
                return false;
            }
        }
        return encoded;
    }

    public static HttpStatus parse(String statusString) {
        HttpStatus httpStatus;
        try {
            int status = Integer.parseInt(statusString);
            httpStatus = HttpStatus.resolve((int)status);
        }
        catch (NumberFormatException e) {
            httpStatus = HttpStatus.valueOf((String)statusString.toUpperCase());
        }
        return httpStatus;
    }

    public static void addOriginalRequestUrl(ServerWebExchange exchange, URI url) {
        exchange.getAttributes().computeIfAbsent(GATEWAY_ORIGINAL_REQUEST_URL_ATTR, s -> new LinkedHashSet());
        LinkedHashSet uris = (LinkedHashSet)exchange.getRequiredAttribute(GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        uris.add(url);
    }

    public static AsyncPredicate<ServerWebExchange> toAsyncPredicate(Predicate<? super ServerWebExchange> predicate) {
        Assert.notNull(predicate, (String)"predicate must not be null");
        return AsyncPredicate.from(predicate);
    }

    public static String expand(ServerWebExchange exchange, String template) {
        Assert.notNull((Object)exchange, (String)"exchange may not be null");
        Assert.notNull((Object)template, (String)"template may not be null");
        if (template.indexOf(123) == -1) {
            return template;
        }
        Map<String, String> variables = ServerWebExchangeUtils.getUriTemplateVariables(exchange);
        return UriComponentsBuilder.fromPath((String)template).build().expand(variables).getPath();
    }

    public static void putUriTemplateVariables(ServerWebExchange exchange, Map<String, String> uriVariables) {
        if (exchange.getAttributes().containsKey(URI_TEMPLATE_VARIABLES_ATTRIBUTE)) {
            Map existingVariables = (Map)exchange.getAttributes().get(URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            HashMap<String, String> newVariables = new HashMap<String, String>();
            newVariables.putAll(existingVariables);
            newVariables.putAll(uriVariables);
            exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, newVariables);
        } else {
            exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
        }
    }

    public static Map<String, String> getUriTemplateVariables(ServerWebExchange exchange) {
        return (Map)exchange.getAttributeOrDefault(URI_TEMPLATE_VARIABLES_ATTRIBUTE, new HashMap());
    }

    public static <T> Mono<T> cacheRequestBodyAndRequest(ServerWebExchange exchange, Function<ServerHttpRequest, Mono<T>> function) {
        return ServerWebExchangeUtils.cacheRequestBody(exchange, true, function);
    }

    public static <T> Mono<T> cacheRequestBody(ServerWebExchange exchange, Function<ServerHttpRequest, Mono<T>> function) {
        return ServerWebExchangeUtils.cacheRequestBody(exchange, false, function);
    }

    private static <T> Mono<T> cacheRequestBody(ServerWebExchange exchange, boolean cacheDecoratedRequest, Function<ServerHttpRequest, Mono<T>> function) {
        Object cachedDataBuffer = exchange.getAttribute(CACHED_REQUEST_BODY_ATTR);
        if (cachedDataBuffer instanceof DataBuffer) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"body already in exchange attribute, short circuiting");
            }
            return Mono.just((Object)exchange.getRequest()).flatMap(function);
        }
        ServerHttpResponse response = exchange.getResponse();
        DataBufferFactory factory = response.bufferFactory();
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).defaultIfEmpty((Object)factory.wrap(EMPTY_BYTES)).map(dataBuffer -> ServerWebExchangeUtils.decorate(exchange, dataBuffer, cacheDecoratedRequest)).switchIfEmpty(Mono.just((Object)exchange.getRequest())).flatMap(function);
    }

    private static ServerHttpRequest decorate(final ServerWebExchange exchange, final DataBuffer dataBuffer, boolean cacheDecoratedRequest) {
        if (dataBuffer.readableByteCount() > 0) {
            Object cachedDataBuffer;
            if (log.isTraceEnabled()) {
                log.trace((Object)"retaining body in exchange attribute");
            }
            if (!((cachedDataBuffer = exchange.getAttribute(CACHED_REQUEST_BODY_ATTR)) instanceof DataBuffer)) {
                exchange.getAttributes().put(CACHED_REQUEST_BODY_ATTR, dataBuffer);
            }
        }
        ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator(exchange.getRequest()){

            public Flux<DataBuffer> getBody() {
                return Mono.fromSupplier(() -> {
                    if (exchange.getAttribute(ServerWebExchangeUtils.CACHED_REQUEST_BODY_ATTR) == null) {
                        return null;
                    }
                    if (dataBuffer instanceof NettyDataBuffer) {
                        NettyDataBuffer pdb = (NettyDataBuffer)dataBuffer;
                        return pdb.factory().wrap(pdb.getNativeBuffer().retainedSlice());
                    }
                    if (dataBuffer instanceof DefaultDataBuffer) {
                        DefaultDataBuffer ddf = (DefaultDataBuffer)dataBuffer;
                        return ddf.factory().wrap(Unpooled.wrappedBuffer((ByteBuffer)ddf.getNativeBuffer()).nioBuffer());
                    }
                    throw new IllegalArgumentException("Unable to handle DataBuffer of type " + dataBuffer.getClass());
                }).flux();
            }
        };
        if (cacheDecoratedRequest) {
            exchange.getAttributes().put(CACHED_SERVER_HTTP_REQUEST_DECORATOR_ATTR, decorator);
        }
        return decorator;
    }

    public static Mono<Void> handle(DispatcherHandler handler, ServerWebExchange exchange) {
        exchange.getAttributes().remove(GATEWAY_PREDICATE_PATH_CONTAINER_ATTR);
        exchange = exchange.mutate().request(request -> request.headers(headers -> headers.setOrigin(null))).build();
        return handler.handle(exchange);
    }
}

