/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AddResponseHeaderGatewayFilterFactory
extends AbstractNameValueGatewayFilterFactory {
    @Override
    public GatewayFilter apply(final AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> AddResponseHeaderGatewayFilterFactory.this.addHeader(exchange, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(AddResponseHeaderGatewayFilterFactory.this).append(config.getName(), (Object)config.getValue()).toString();
            }
        };
    }

    void addHeader(ServerWebExchange exchange, AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        String value = ServerWebExchangeUtils.expand(exchange, config.getValue());
        HttpHeaders headers = exchange.getResponse().getHeaders();
        if (!exchange.getResponse().isCommitted()) {
            headers.add(config.getName(), value);
        }
    }
}

