/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManager;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseCacheGatewayFilter
implements GatewayFilter,
Ordered {
    private final ResponseCacheManager responseCacheManager;

    public ResponseCacheGatewayFilter(ResponseCacheManager responseCacheManager) {
        this.responseCacheManager = responseCacheManager;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (this.responseCacheManager.isRequestCacheable(exchange.getRequest())) {
            exchange.getAttributes().put("LocalResponseCacheGatewayFilter-Applied", true);
            return this.filterWithCache(exchange, chain);
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -4;
    }

    private Mono<Void> filterWithCache(ServerWebExchange exchange, GatewayFilterChain chain) {
        String metadataKey = this.responseCacheManager.resolveMetadataKey(exchange);
        Optional<CachedResponse> cached = this.getCachedResponse(exchange, metadataKey);
        if (cached.isPresent()) {
            return this.responseCacheManager.processFromCache(exchange, metadataKey, cached.get());
        }
        return chain.filter(exchange.mutate().response((ServerHttpResponse)new CachingResponseDecorator(metadataKey, exchange)).build());
    }

    private Optional<CachedResponse> getCachedResponse(ServerWebExchange exchange, String metadataKey) {
        Optional<CachedResponse> cached = this.shouldRevalidate(exchange) ? Optional.empty() : this.responseCacheManager.getFromCache(exchange.getRequest(), metadataKey);
        return cached;
    }

    private boolean shouldRevalidate(ServerWebExchange exchange) {
        return LocalResponseCacheUtils.isNoCacheRequest(exchange.getRequest());
    }

    private class CachingResponseDecorator
    extends ServerHttpResponseDecorator {
        private final String metadataKey;
        private final ServerWebExchange exchange;

        CachingResponseDecorator(String metadataKey, ServerWebExchange exchange) {
            super(exchange.getResponse());
            this.metadataKey = metadataKey;
            this.exchange = exchange;
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
            ServerHttpResponse response = this.exchange.getResponse();
            Flux<DataBuffer> decoratedBody = ResponseCacheGatewayFilter.this.responseCacheManager.isResponseCacheable(response) && !ResponseCacheGatewayFilter.this.responseCacheManager.isNoCacheRequestWithoutUpdate(this.exchange.getRequest()) ? ResponseCacheGatewayFilter.this.responseCacheManager.processFromUpstream(this.metadataKey, this.exchange, (Flux<DataBuffer>)Flux.from(body)) : Flux.from(body);
            return super.writeWith((Publisher)decoratedBody);
        }
    }
}

