/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.config;

import com.google.api.gax.core.CredentialsProvider;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.config.GcpConfigProperties;
import org.springframework.cloud.gcp.autoconfigure.config.GoogleConfigPropertySourceLocator;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="spring.cloud.gcp.config", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={GcpConfigProperties.class})
public class GcpConfigBootstrapConfiguration {
    @Bean
    public GoogleConfigPropertySourceLocator googleConfigPropertySourceLocator(GcpConfigProperties configProperties) throws IOException {
        return new GoogleConfigPropertySourceLocator((GcpProjectIdProvider)new DefaultGcpProjectIdProvider(), (CredentialsProvider)new DefaultCredentialsProvider((CredentialsSupplier)configProperties), configProperties);
    }
}

