/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.security;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.security.FirebaseAuthenticationProperties;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.security.firebase.FirebaseJwtTokenDecoder;
import org.springframework.cloud.gcp.security.firebase.FirebaseTokenValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={JwtIssuerValidator.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.security.firebase.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@EnableConfigurationProperties(value={FirebaseAuthenticationProperties.class})
public class FirebaseAuthenticationAutoConfiguration {
    private static final String ISSUER_TEMPLATE = "https://securetoken.google.com/%s";

    @Bean
    @ConditionalOnMissingBean(name={"firebaseJwtDelegatingValidator"})
    public DelegatingOAuth2TokenValidator<Jwt> firebaseJwtDelegatingValidator(JwtIssuerValidator jwtIssuerValidator, GcpProjectIdProvider gcpProjectIdProvider) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(jwtIssuerValidator);
        validators.add(new FirebaseTokenValidator(gcpProjectIdProvider.getProjectId()));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    @Bean
    @ConditionalOnMissingBean(name={"firebaseAuthenticationJwtDecoder"})
    public JwtDecoder firebaseAuthenticationJwtDecoder(DelegatingOAuth2TokenValidator<Jwt> firebaseJwtDelegatingValidator, FirebaseAuthenticationProperties properties) {
        return new FirebaseJwtTokenDecoder(this.restOperations(), properties.getPublicKeysEndpoint(), firebaseJwtDelegatingValidator);
    }

    @Bean
    public JwtIssuerValidator jwtIssuerValidator(GcpProjectIdProvider gcpProjectIdProvider) {
        return new JwtIssuerValidator(String.format(ISSUER_TEMPLATE, gcpProjectIdProvider.getProjectId()));
    }

    private RestOperations restOperations() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(2000);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

