/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

public final class SpannerConverters {
    public static final Converter<java.sql.Date, Date> JAVA_SQL_TO_SPANNER_DATE_CONVERTER = new Converter<java.sql.Date, Date>(){

        @Nullable
        public Date convert(java.sql.Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return Date.fromYearMonthDay((int)cal.get(1), (int)(cal.get(2) + 1), (int)cal.get(5));
        }
    };
    public static final Converter<Date, java.sql.Date> SPANNER_TO_JAVA_SQL_DATE_CONVERTER = new Converter<Date, java.sql.Date>(){

        @Nullable
        public java.sql.Date convert(Date date) {
            Calendar cal = Calendar.getInstance();
            cal.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
            return new java.sql.Date(cal.getTimeInMillis());
        }
    };
    public static final Converter<java.util.Date, Date> JAVA_TO_SPANNER_DATE_CONVERTER = new Converter<java.util.Date, Date>(){

        @Nullable
        public Date convert(java.util.Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return Date.fromYearMonthDay((int)cal.get(1), (int)(cal.get(2) + 1), (int)cal.get(5));
        }
    };
    public static final Converter<Date, java.util.Date> SPANNER_TO_JAVA_DATE_CONVERTER = new Converter<Date, java.util.Date>(){

        @Nullable
        public java.util.Date convert(Date date) {
            Calendar cal = Calendar.getInstance();
            cal.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
            return cal.getTime();
        }
    };
    public static final Converter<Instant, com.google.cloud.Timestamp> INSTANT_TIMESTAMP_CONVERTER = new Converter<Instant, com.google.cloud.Timestamp>(){

        @Nullable
        public com.google.cloud.Timestamp convert(Instant instant) {
            return com.google.cloud.Timestamp.ofTimeSecondsAndNanos((long)instant.getEpochSecond(), (int)instant.getNano());
        }
    };
    public static final Converter<com.google.cloud.Timestamp, Instant> TIMESTAMP_INSTANT_CONVERTER = new Converter<com.google.cloud.Timestamp, Instant>(){

        @Nullable
        public Instant convert(com.google.cloud.Timestamp timestamp) {
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }
    };
    public static final Converter<Timestamp, com.google.cloud.Timestamp> JAVA_TO_SPANNER_TIMESTAMP_CONVERTER = new Converter<Timestamp, com.google.cloud.Timestamp>(){

        @Nullable
        public com.google.cloud.Timestamp convert(Timestamp timestamp) {
            return com.google.cloud.Timestamp.of((Timestamp)timestamp);
        }
    };
    public static final Converter<com.google.cloud.Timestamp, Timestamp> SPANNER_TO_JAVA_TIMESTAMP_CONVERTER = new Converter<com.google.cloud.Timestamp, Timestamp>(){

        @Nullable
        public Timestamp convert(com.google.cloud.Timestamp timestamp) {
            return Timestamp.from((Instant)TIMESTAMP_INSTANT_CONVERTER.convert((Object)timestamp));
        }
    };
    public static final Converter<byte[], ByteArray> JAVA_TO_SPANNER_BYTE_ARRAY_CONVERTER = new Converter<byte[], ByteArray>(){

        @Nullable
        public ByteArray convert(byte[] bytes) {
            return ByteArray.copyFrom((byte[])bytes);
        }
    };
    public static final Converter<ByteArray, byte[]> SPANNER_TO_JAVA_BYTE_ARRAY_CONVERTER = new Converter<ByteArray, byte[]>(){

        @Nullable
        public byte[] convert(ByteArray bytes) {
            return bytes.toByteArray();
        }
    };
    public static final Collection<Converter> DEFAULT_SPANNER_WRITE_CONVERTERS = ImmutableSet.of(JAVA_TO_SPANNER_DATE_CONVERTER, INSTANT_TIMESTAMP_CONVERTER, JAVA_TO_SPANNER_BYTE_ARRAY_CONVERTER, JAVA_TO_SPANNER_TIMESTAMP_CONVERTER, JAVA_SQL_TO_SPANNER_DATE_CONVERTER);
    public static final Collection<Converter> DEFAULT_SPANNER_READ_CONVERTERS = ImmutableSet.of(SPANNER_TO_JAVA_DATE_CONVERTER, TIMESTAMP_INSTANT_CONVERTER, SPANNER_TO_JAVA_BYTE_ARRAY_CONVERTER, SPANNER_TO_JAVA_TIMESTAMP_CONVERTER, SPANNER_TO_JAVA_SQL_DATE_CONVERTER);

    private SpannerConverters() {
    }
}

