/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.logging;

import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import org.slf4j.MDC;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.logging.StackdriverTraceConstants;

public class TraceIdLoggingEnhancer
implements LoggingEnhancer {
    private static final ThreadLocal<String> traceId = new ThreadLocal();
    private static final String APP_ENGINE_LABEL_NAME = "appengine.googleapis.com/trace_id";
    private GcpProjectIdProvider projectIdProvider = new DefaultGcpProjectIdProvider();
    private boolean runningOnAppEngine = System.getenv("GAE_INSTANCE") != null;

    public static void setCurrentTraceId(String id) {
        if (id == null) {
            traceId.remove();
        } else {
            traceId.set(id);
        }
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    public void enhanceLogEntry(LogEntry.Builder builder) {
        String traceId = MDC.get((String)"X-B3-TraceId");
        String spanId = MDC.get((String)"X-B3-SpanId");
        if (traceId == null) {
            traceId = TraceIdLoggingEnhancer.getCurrentTraceId();
        }
        if (traceId != null) {
            builder.setTrace(StackdriverTraceConstants.composeFullTraceName(this.projectIdProvider.getProjectId(), traceId));
            if (this.runningOnAppEngine) {
                builder.addLabel(APP_ENGINE_LABEL_NAME, traceId);
            }
        }
        if (spanId != null) {
            builder.setSpanId(spanId);
        }
    }
}

