/*
 * Copyright 2017-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.gcp.stream.binder.pubsub.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.AbstractExtendedBindingProperties;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;

/**
 * Extended binding properties for Pub/Sub.
 *
 * @author João André Martins
 * @author Artem Bilan
 * @author Daniel Zou
 */
@ConfigurationProperties("spring.cloud.stream.gcp.pubsub")
public class PubSubExtendedBindingProperties extends
		AbstractExtendedBindingProperties<PubSubConsumerProperties, PubSubProducerProperties, PubSubBindingProperties> {

	private static final String DEFAULTS_PREFIX = "spring.cloud.stream.gcp.pubsub.default";

	@Override
	public String getDefaultsPrefix() {
		return DEFAULTS_PREFIX;
	}

	@Override
	public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
		return PubSubBindingProperties.class;
	}

}
