/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.integration.inbound;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import org.springframework.cloud.gcp.pubsub.core.PubSubException;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.pubsub.integration.AckMode;
import org.springframework.cloud.gcp.pubsub.integration.PubSubHeaderMapper;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class PubSubInboundChannelAdapter
extends MessageProducerSupport {
    private final String subscriptionName;
    private final PubSubTemplate pubSubTemplate;
    private Subscriber subscriber;
    private AckMode ackMode = AckMode.AUTO;
    private HeaderMapper<Map<String, String>> headerMapper = new PubSubHeaderMapper();
    private Class payloadType = byte[].class;

    public PubSubInboundChannelAdapter(PubSubTemplate pubSubTemplate, String subscriptionName) {
        this.pubSubTemplate = pubSubTemplate;
        this.subscriptionName = subscriptionName;
    }

    protected void doStart() {
        super.doStart();
        this.subscriber = this.pubSubTemplate.subscribe(this.subscriptionName, this::receiveMessage);
    }

    private void receiveMessage(PubsubMessage pubsubMessage, AckReplyConsumer consumer) {
        Map messageHeaders = this.headerMapper.toHeaders((Object)pubsubMessage.getAttributesMap());
        if (this.ackMode == AckMode.MANUAL) {
            messageHeaders.put("gcp_pubsub_acknowledgement", consumer);
        }
        try {
            this.sendMessage(MessageBuilder.withPayload(this.pubSubTemplate.getMessageConverter().fromPubSubMessage(pubsubMessage, this.payloadType)).copyHeaders(messageHeaders).build());
        }
        catch (RuntimeException re) {
            if (this.ackMode == AckMode.AUTO) {
                consumer.nack();
            }
            throw new PubSubException("Sending Spring message failed.", re);
        }
        if (this.ackMode == AckMode.AUTO) {
            consumer.ack();
        }
    }

    protected void doStop() {
        if (this.subscriber != null) {
            this.subscriber.stopAsync();
        }
        super.doStop();
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"The acknowledgement mode can't be null.");
        this.ackMode = ackMode;
    }

    public Class getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(Class payloadType) {
        Assert.notNull((Object)payloadType, (String)"The payload type cannot be null.");
        this.payloadType = payloadType;
    }

    public void setHeaderMapper(HeaderMapper<Map<String, String>> headerMapper) {
        Assert.notNull(headerMapper, (String)"The header mapper can't be null.");
        this.headerMapper = headerMapper;
    }
}

