/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.integration.outbound;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.pubsub.core.PubSubOperations;
import org.springframework.cloud.gcp.pubsub.integration.PubSubHeaderMapper;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class PubSubMessageHandler
extends AbstractMessageHandler {
    private static final long DEFAULT_PUBLISH_TIMEOUT = 10000L;
    private final PubSubOperations pubSubTemplate;
    private Expression topicExpression;
    private boolean sync;
    private EvaluationContext evaluationContext;
    private Expression publishTimeoutExpression = new ValueExpression((Object)10000L);
    private ListenableFutureCallback<String> publishCallback;
    private HeaderMapper<Map<String, String>> headerMapper = new PubSubHeaderMapper();

    public PubSubMessageHandler(PubSubOperations pubSubTemplate, String topic) {
        Assert.notNull((Object)pubSubTemplate, (String)"Pub/Sub template cannot be null.");
        Assert.notNull((Object)topic, (String)"Pub/Sub topic cannot be null.");
        this.pubSubTemplate = pubSubTemplate;
        this.topicExpression = new LiteralExpression(topic);
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object payload = message.getPayload();
        String topic = message.getHeaders().containsKey((Object)"gcp_pubsub_topic") ? (String)message.getHeaders().get((Object)"gcp_pubsub_topic", String.class) : (String)this.topicExpression.getValue(this.evaluationContext, message, String.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.headerMapper.fromHeaders(message.getHeaders(), headers);
        ListenableFuture<String> pubsubFuture = this.pubSubTemplate.publish(topic, payload, headers);
        if (this.publishCallback != null) {
            pubsubFuture.addCallback(this.publishCallback);
        }
        if (this.sync) {
            Long timeout = (Long)this.publishTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
            if (timeout == null || timeout < 0L) {
                pubsubFuture.get();
            } else {
                pubsubFuture.get(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Expression getPublishTimeoutExpression() {
        return this.publishTimeoutExpression;
    }

    public void setPublishTimeoutExpression(Expression publishTimeoutExpression) {
        Assert.notNull((Object)publishTimeoutExpression, (String)"Publish timeout expression can't be null.");
        this.publishTimeoutExpression = publishTimeoutExpression;
    }

    public void setPublishTimeoutExpressionString(String publishTimeoutExpression) {
        Assert.notNull((Object)publishTimeoutExpression, (String)"Publish timeout expression can't be null.");
        this.setPublishTimeoutExpression(EXPRESSION_PARSER.parseExpression(publishTimeoutExpression));
    }

    public void setPublishTimeout(long timeoutMillis) {
        this.setPublishTimeoutExpression((Expression)new ValueExpression((Object)timeoutMillis));
    }

    protected ListenableFutureCallback<String> getPublishCallback() {
        return this.publishCallback;
    }

    public void setPublishCallback(ListenableFutureCallback<String> publishCallback) {
        this.publishCallback = publishCallback;
    }

    public Expression getTopicExpression() {
        return this.topicExpression;
    }

    public void setTopicExpression(Expression topicExpression) {
        this.topicExpression = topicExpression;
    }

    public void setTopic(String topic) {
        this.topicExpression = new LiteralExpression(topic);
    }

    public void setTopicExpressionString(String topicExpressionString) {
        this.topicExpression = EXPRESSION_PARSER.parseExpression(topicExpressionString);
    }

    public void setHeaderMapper(HeaderMapper<Map<String, String>> headerMapper) {
        Assert.notNull(headerMapper, (String)"The header mapper can't be null.");
        this.headerMapper = headerMapper;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }
}

