/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.models.V1Pod;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.kubernetes.client.KubernetesClientHealthIndicator;
import org.springframework.cloud.kubernetes.client.KubernetesClientInfoContributor;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnKubernetesEnabled
public class KubernetesClientActuatorConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="kubernetes")
    public KubernetesClientHealthIndicator kubernetesHealthIndicator(PodUtils<V1Pod> podUtils) {
        return new KubernetesClientHealthIndicator(podUtils);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="kubernetes")
    public KubernetesClientInfoContributor kubernetesInfoContributor(PodUtils<V1Pod> podUtils) {
        return new KubernetesClientInfoContributor(podUtils);
    }
}

