/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class KubernetesClientConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private CoreV1Api coreV1Api;
    private KubernetesClientProperties kubernetesClientProperties;
    private KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesClientProperties kubernetesClientProperties) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
    }

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    protected MapPropertySource getMapPropertySource(String name, ConfigMapConfigProperties.NormalizedSource normalizedSource, String configurationTarget, ConfigurableEnvironment environment) {
        String fallbackNamespace = this.kubernetesNamespaceProvider != null ? this.kubernetesNamespaceProvider.getNamespace() : this.kubernetesClientProperties.getNamespace();
        return new KubernetesClientConfigMapPropertySource(this.coreV1Api, name, KubernetesClientConfigUtils.getNamespace(normalizedSource, fallbackNamespace), (Environment)environment);
    }
}

