/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config.reload;

import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class KubernetesClientEventBasedSecretsChangeDetector
extends ConfigurationChangeDetector {
    private static final Log LOG = LogFactory.getLog(KubernetesClientEventBasedSecretsChangeDetector.class);
    private CoreV1Api coreV1Api;
    private KubernetesClientSecretsPropertySourceLocator propertySourceLocator;
    private SharedInformerFactory factory;
    private KubernetesClientProperties kubernetesClientProperties;
    private KubernetesNamespaceProvider kubernetesNamespaceProvider;

    @Deprecated
    public KubernetesClientEventBasedSecretsChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator propertySourceLocator, KubernetesClientProperties kubernetesClientProperties) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.factory = new SharedInformerFactory();
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
    }

    public KubernetesClientEventBasedSecretsChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator propertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.factory = new SharedInformerFactory();
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    @Deprecated
    public KubernetesClientEventBasedSecretsChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator propertySourceLocator, KubernetesClientProperties kubernetesClientProperties) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.factory = new SharedInformerFactory();
        this.kubernetesClientProperties = kubernetesClientProperties;
        try {
            ApiClient apiClient = KubernetesClientUtils.kubernetesApiClient();
            OkHttpClient httpClient = apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build();
            apiClient.setHttpClient(httpClient);
            this.coreV1Api = new CoreV1Api(apiClient);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create Kubernetes API client.  Event based ConfigMap monitoring will not work", (Throwable)e);
        }
    }

    private String getNamespace() {
        return this.kubernetesNamespaceProvider != null ? this.kubernetesNamespaceProvider.getNamespace() : this.kubernetesClientProperties.getNamespace();
    }

    @PostConstruct
    public void watch() {
        if (this.coreV1Api != null && this.properties.isMonitoringSecrets()) {
            SharedIndexInformer configMapInformer = this.factory.sharedIndexInformerFor(params -> this.coreV1Api.listNamespacedSecretCall(this.getNamespace(), null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Secret.class, V1SecretList.class);
            configMapInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Secret>(){

                public void onAdd(V1Secret obj) {
                    LOG.info((Object)("Secret " + obj.getMetadata().getName() + " was added."));
                    KubernetesClientEventBasedSecretsChangeDetector.this.onEvent(obj);
                }

                public void onUpdate(V1Secret oldObj, V1Secret newObj) {
                    LOG.info((Object)("Secret " + newObj.getMetadata().getName() + " was added."));
                    KubernetesClientEventBasedSecretsChangeDetector.this.onEvent(newObj);
                }

                public void onDelete(V1Secret obj, boolean deletedFinalStateUnknown) {
                    LOG.info((Object)("Secret " + obj.getMetadata() + " was deleted."));
                    KubernetesClientEventBasedSecretsChangeDetector.this.onEvent(obj);
                }
            });
            this.factory.startAllRegisteredInformers();
        }
    }

    private void onEvent(V1Secret secret) {
        this.log.debug((Object)String.format("onEvent configMap: %s", secret.toString()));
        boolean changed = this.changed(this.locateMapPropertySources((PropertySourceLocator)this.propertySourceLocator, (Environment)this.environment), this.findPropertySources(KubernetesClientSecretsPropertySource.class));
        if (changed) {
            this.log.info((Object)"Detected change in secrets");
            this.reloadProperties();
        }
    }
}

