/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapsCache;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsCache;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigDataLocationResolver;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.env.Environment;

public class KubernetesClientConfigDataLocationResolver
extends KubernetesConfigDataLocationResolver {
    public KubernetesClientConfigDataLocationResolver(DeferredLogFactory factory) {
        super(factory);
    }

    protected void registerBeans(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles, KubernetesConfigDataLocationResolver.PropertyHolder propertyHolder, KubernetesNamespaceProvider namespaceProvider) {
        KubernetesClientProperties kubernetesClientProperties = propertyHolder.kubernetesClientProperties();
        ConfigMapConfigProperties configMapProperties = propertyHolder.configMapConfigProperties();
        SecretsConfigProperties secretsProperties = propertyHolder.secretsProperties();
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        CoreV1Api coreV1Api = this.registerClientAndCoreV1Api(bootstrapContext, kubernetesClientProperties);
        if (configMapProperties != null && configMapProperties.enabled()) {
            KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator = new KubernetesClientConfigMapPropertySourceLocator(coreV1Api, configMapProperties, namespaceProvider);
            if (this.isRetryEnabledForConfigMap(configMapProperties)) {
                configMapPropertySourceLocator = new ConfigDataRetryableConfigMapPropertySourceLocator((ConfigMapPropertySourceLocator)configMapPropertySourceLocator, configMapProperties, (ConfigMapCache)new KubernetesClientConfigMapsCache());
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, ConfigMapPropertySourceLocator.class, (Object)((Object)configMapPropertySourceLocator), (String)"configDataConfigMapPropertySourceLocator");
        }
        if (secretsProperties != null && secretsProperties.enabled()) {
            KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator = new KubernetesClientSecretsPropertySourceLocator(coreV1Api, namespaceProvider, secretsProperties);
            if (this.isRetryEnabledForSecrets(secretsProperties)) {
                secretsPropertySourceLocator = new ConfigDataRetryableSecretsPropertySourceLocator((SecretsPropertySourceLocator)secretsPropertySourceLocator, secretsProperties, (SecretsCache)new KubernetesClientSecretsCache());
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, SecretsPropertySourceLocator.class, (Object)((Object)secretsPropertySourceLocator), (String)"configDataSecretsPropertySourceLocator");
        }
    }

    private CoreV1Api registerClientAndCoreV1Api(ConfigurableBootstrapContext bootstrapContext, KubernetesClientProperties kubernetesClientProperties) {
        ApiClient apiClient = KubernetesClientUtils.kubernetesApiClient();
        apiClient.setUserAgent(kubernetesClientProperties.userAgent());
        ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, ApiClient.class, (Object)apiClient, (String)"configDataApiClient");
        CoreV1Api coreV1Api = new CoreV1Api(apiClient);
        ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, CoreV1Api.class, (Object)coreV1Api, (String)"configCoreV1Api");
        return coreV1Api;
    }

    protected KubernetesNamespaceProvider kubernetesNamespaceProvider(Environment environment) {
        return new KubernetesNamespaceProvider(environment);
    }
}

