/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public class KubernetesNamespaceProvider
implements ApplicationListener<ApplicationEvent> {
    public static final String NAMESPACE_PROPERTY = "spring.cloud.kubernetes.client.namespace";
    public static final String NAMESPACE_PATH_PROPERTY = "spring.cloud.kubernetes.client.serviceAccountNamespacePath";
    private static final DeferredLog LOG = new DeferredLog();
    private String serviceAccountNamespace;
    private Environment environment;

    public KubernetesNamespaceProvider(Environment env) {
        this.environment = env;
    }

    public String getNamespace() {
        String namespace = this.environment.getProperty(NAMESPACE_PROPERTY);
        if (namespace == null) {
            namespace = this.getServiceAccountNamespace();
        }
        return namespace;
    }

    private String getServiceAccountNamespace() {
        String serviceAccountNamespacePathString = this.environment.getProperty(NAMESPACE_PATH_PROPERTY, "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        if (this.serviceAccountNamespace == null) {
            this.serviceAccountNamespace = KubernetesNamespaceProvider.getNamespaceFromServiceAccountFile(serviceAccountNamespacePathString);
        }
        return this.serviceAccountNamespace;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        LOG.replayTo(KubernetesNamespaceProvider.class);
    }

    public static String getNamespaceFromServiceAccountFile(String path) {
        Path serviceAccountNamespacePath;
        boolean serviceAccountNamespaceExists;
        String namespace = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for service account namespace at: [" + path + "]."));
        }
        if (serviceAccountNamespaceExists = Files.isRegularFile(serviceAccountNamespacePath = Paths.get(path, new String[0]), new LinkOption[0])) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found service account namespace at: [" + serviceAccountNamespacePath + "]."));
            }
            try {
                namespace = new String(Files.readAllBytes(serviceAccountNamespacePath));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service account namespace value: " + serviceAccountNamespacePath));
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("Error reading service account namespace from: [" + serviceAccountNamespacePath + "]."), (Throwable)ioe);
            }
        }
        return namespace;
    }
}

