/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.profile;

import java.util.Arrays;
import java.util.Collections;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public abstract class AbstractKubernetesProfileEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final DeferredLog LOG = new DeferredLog();
    private static final String NAMESPACE_PATH_PROPERTY = "spring.cloud.kubernetes.client.serviceAccountNamespacePath";
    protected static final String NAMESPACE_PROPERTY = "spring.cloud.kubernetes.client.namespace";
    private static final String PROPERTY_SOURCE_NAME = "KUBERNETES_NAMESPACE_PROPERTY_SOURCE";
    private static final int ORDER = -2147483639;
    public static final String KUBERNETES_PROFILE = "kubernetes";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        application.addInitializers(new ApplicationContextInitializer[]{ctx -> LOG.replayTo(AbstractKubernetesProfileEnvironmentPostProcessor.class)});
        if (CloudPlatform.KUBERNETES.isActive((Environment)environment)) {
            this.addNamespaceFromServiceAccountFile(environment);
            this.addKubernetesProfileIfMissing(environment);
        }
    }

    protected abstract boolean isInsideKubernetes(Environment var1);

    private boolean hasKubernetesProfile(Environment environment) {
        return Arrays.stream(environment.getActiveProfiles()).anyMatch(KUBERNETES_PROFILE::equalsIgnoreCase);
    }

    public int getOrder() {
        return -2147483639;
    }

    private void addKubernetesProfileIfMissing(ConfigurableEnvironment environment) {
        if (this.isInsideKubernetes((Environment)environment)) {
            if (this.hasKubernetesProfile((Environment)environment)) {
                LOG.debug((Object)"'kubernetes' already in list of active profiles");
            } else {
                LOG.debug((Object)"Adding 'kubernetes' to list of active profiles");
                environment.addActiveProfile(KUBERNETES_PROFILE);
            }
        } else {
            LOG.warn((Object)"Not running inside kubernetes. Skipping 'kubernetes' profile activation.");
        }
    }

    private void addNamespaceFromServiceAccountFile(ConfigurableEnvironment environment) {
        String serviceAccountNamespacePathString = environment.getProperty(NAMESPACE_PATH_PROPERTY, "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        String namespace = KubernetesNamespaceProvider.getNamespaceFromServiceAccountFile(serviceAccountNamespacePathString);
        if (StringUtils.hasText((String)namespace)) {
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, Collections.singletonMap(NAMESPACE_PROPERTY, namespace)));
        }
    }
}

