/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigDataResource;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;

public abstract class KubernetesConfigDataLocationResolver
implements ConfigDataLocationResolver<KubernetesConfigDataResource>,
Ordered {
    private static final boolean RETRY_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.retry.annotation.Retryable", null);
    private final Log log;

    public KubernetesConfigDataLocationResolver(DeferredLogFactory factory) {
        this.log = factory.getLog(KubernetesConfigDataLocationResolver.class);
    }

    protected final String getPrefix() {
        return "kubernetes:";
    }

    public final int getOrder() {
        return -1;
    }

    public final boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(this.getPrefix()) && (CloudPlatform.KUBERNETES.isEnforced(context.getBinder()) || CloudPlatform.KUBERNETES.isDetected((Environment)new StandardEnvironment()));
    }

    public final List<KubernetesConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public final List<KubernetesConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        PropertyHolder propertyHolder = PropertyHolder.of(resolverContext);
        KubernetesClientProperties clientProperties = propertyHolder.kubernetesClientProperties();
        ConfigMapConfigProperties configMapProperties = propertyHolder.configMapConfigProperties();
        SecretsConfigProperties secretsProperties = propertyHolder.secretsProperties();
        this.registerProperties(resolverContext, clientProperties, configMapProperties, secretsProperties);
        HashMap<String, String> kubernetesConfigData = new HashMap<String, String>();
        kubernetesConfigData.put("spring.cloud.kubernetes.client.namespace", clientProperties.namespace());
        if (propertyHolder.applicationName() != null) {
            kubernetesConfigData.put("spring.application.name", propertyHolder.applicationName());
        }
        MapPropertySource propertySource = new MapPropertySource("kubernetesConfigData", kubernetesConfigData);
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setActiveProfiles(profiles.getAccepted().toArray(new String[0]));
        KubernetesNamespaceProvider namespaceProvider = this.kubernetesNamespaceProvider((Environment)environment);
        this.registerBeans(resolverContext, location, profiles, propertyHolder, namespaceProvider);
        KubernetesConfigDataResource resource = new KubernetesConfigDataResource(clientProperties, configMapProperties, secretsProperties, location.isOptional(), profiles, (Environment)environment);
        resource.setLog(this.log);
        return List.of(resource);
    }

    protected abstract void registerBeans(ConfigDataLocationResolverContext var1, ConfigDataLocation var2, Profiles var3, PropertyHolder var4, KubernetesNamespaceProvider var5);

    protected final boolean isRetryEnabledForConfigMap(ConfigMapConfigProperties configMapProperties) {
        return RETRY_IS_PRESENT && configMapProperties != null && configMapProperties.retry().enabled() && configMapProperties.failFast();
    }

    protected final boolean isRetryEnabledForSecrets(SecretsConfigProperties secretsProperties) {
        return RETRY_IS_PRESENT && secretsProperties != null && secretsProperties.retry().enabled() && secretsProperties.failFast();
    }

    protected KubernetesNamespaceProvider kubernetesNamespaceProvider(Environment environment) {
        return new KubernetesNamespaceProvider(environment);
    }

    private void registerProperties(ConfigDataLocationResolverContext resolverContext, KubernetesClientProperties clientProperties, ConfigMapConfigProperties configMapProperties, SecretsConfigProperties secretsProperties) {
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        ConfigUtils.registerSingle(bootstrapContext, KubernetesClientProperties.class, clientProperties, "configDataKubernetesClientProperties");
        if (configMapProperties != null) {
            ConfigUtils.registerSingle(bootstrapContext, ConfigMapConfigProperties.class, configMapProperties, "configDataConfigMapConfigProperties");
        }
        if (secretsProperties != null) {
            ConfigUtils.registerSingle(bootstrapContext, SecretsConfigProperties.class, secretsProperties, "configDataSecretsConfigProperties");
        }
    }

    protected record PropertyHolder(KubernetesClientProperties kubernetesClientProperties, ConfigMapConfigProperties configMapConfigProperties, SecretsConfigProperties secretsProperties, String applicationName) {
        private static PropertyHolder of(ConfigDataLocationResolverContext context) {
            Binder binder = context.getBinder();
            String applicationName = (String)binder.bind("spring.application.name", String.class).orElse(null);
            String namespace = (String)binder.bind("spring.cloud.kubernetes.client.namespace", String.class).orElse((Object)((String)binder.bind("kubernetes.namespace", String.class).orElse((Object)"")));
            KubernetesClientProperties kubernetesClientProperties = PropertyHolder.clientProperties(context, namespace);
            ConfigMapAndSecrets both = ConfigMapAndSecrets.of(binder);
            return new PropertyHolder(kubernetesClientProperties, both.configMapProperties(), both.secretsConfigProperties(), applicationName);
        }

        private static KubernetesClientProperties clientProperties(ConfigDataLocationResolverContext context, String namespace) {
            KubernetesClientProperties kubernetesClientProperties = context.getBootstrapContext().isRegistered(KubernetesClientProperties.class) ? ((KubernetesClientProperties)context.getBootstrapContext().get(KubernetesClientProperties.class)).withNamespace(namespace) : ((KubernetesClientProperties)context.getBinder().bindOrCreate("spring.cloud.kubernetes.client", Bindable.of(KubernetesClientProperties.class))).withNamespace(namespace);
            return kubernetesClientProperties;
        }
    }

    private record ConfigMapAndSecrets(ConfigMapConfigProperties configMapProperties, SecretsConfigProperties secretsConfigProperties) {
        private static ConfigMapAndSecrets of(Binder binder) {
            boolean configEnabled = (Boolean)binder.bind("spring.cloud.kubernetes.config.enabled", Boolean.TYPE).orElse((Object)true);
            boolean secretsEnabled = (Boolean)binder.bind("spring.cloud.kubernetes.secrets.enabled", Boolean.TYPE).orElse((Object)true);
            ConfigMapConfigProperties configMapConfigProperties = null;
            if (configEnabled) {
                configMapConfigProperties = (ConfigMapConfigProperties)binder.bindOrCreate("spring.cloud.kubernetes.config", ConfigMapConfigProperties.class);
            }
            SecretsConfigProperties secretsProperties = null;
            if (secretsEnabled) {
                secretsProperties = (SecretsConfigProperties)binder.bindOrCreate("spring.cloud.kubernetes.secrets", SecretsConfigProperties.class);
            }
            return new ConfigMapAndSecrets(configMapConfigProperties, secretsProperties);
        }
    }
}

