/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.config.ConfigUtils;
import org.springframework.cloud.kubernetes.config.KubernetesPropertySource;
import org.springframework.cloud.kubernetes.config.SecretsConfigProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SecretsPropertySource
extends KubernetesPropertySource {
    private static final Log LOG = LogFactory.getLog(SecretsPropertySource.class);
    private static final String PREFIX = "secrets";

    public SecretsPropertySource(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        super(SecretsPropertySource.getSourceName(client, env, config), SecretsPropertySource.getSourceData(client, env, config));
    }

    private static String getSourceName(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        return PREFIX + "." + ConfigUtils.getApplicationName(env, config.getName(), config.getConfigurationTarget()) + "." + ConfigUtils.getApplicationNamespace(client, config.getNamespace(), config.getConfigurationTarget());
    }

    private static Map<String, Object> getSourceData(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        String name = ConfigUtils.getApplicationName(env, config.getName(), config.getConfigurationTarget());
        String namespace = ConfigUtils.getApplicationNamespace(client, config.getNamespace(), config.getConfigurationTarget());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (config.isEnableApi()) {
            try {
                Secret secret = StringUtils.isEmpty((Object)namespace) ? (Secret)((Resource)client.secrets().withName(name)).get() : (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get();
                SecretsPropertySource.putAll(secret, result);
                if (!config.getLabels().isEmpty()) {
                    if (StringUtils.isEmpty((Object)namespace)) {
                        ((SecretList)((FilterWatchListDeletable)client.secrets().withLabels(config.getLabels())).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, result));
                    } else {
                        ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(config.getLabels())).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, result));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + config.getLabels() + "] in namespace:[" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"));
            }
        }
        SecretsPropertySource.putPathConfig(result, config.getPaths());
        return result;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " {name='" + this.name + "'}";
    }

    private static void putAll(Secret secret, Map<String, Object> result) {
        if (secret != null && secret.getData() != null) {
            secret.getData().forEach((k, v) -> result.put((String)k, new String(Base64.getDecoder().decode((String)v)).trim()));
        }
    }
}

