/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.config.reload.EventBasedConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.config.reload.PollingConfigurationChangeDetector;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigReloadProperties.class})
public class ConfigReloadAutoConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"})
    @ConditionalOnClass(value={RestartEndpoint.class, ContextRefresher.class})
    @EnableScheduling
    @EnableAsync
    protected static class ConfigReloadAutoConfigurationBeans {
        @Autowired
        private AbstractEnvironment environment;
        @Autowired
        private KubernetesClient kubernetesClient;
        @Autowired
        private ConfigMapPropertySourceLocator configMapPropertySourceLocator;
        @Autowired
        private SecretsPropertySourceLocator secretsPropertySourceLocator;

        protected ConfigReloadAutoConfigurationBeans() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationChangeDetector propertyChangeWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy) {
            switch (properties.getMode()) {
                case POLLING: {
                    return new PollingConfigurationChangeDetector(this.environment, properties, this.kubernetesClient, strategy, this.configMapPropertySourceLocator, this.secretsPropertySourceLocator);
                }
                case EVENT: {
                    return new EventBasedConfigurationChangeDetector(this.environment, properties, this.kubernetesClient, strategy, this.configMapPropertySourceLocator, this.secretsPropertySourceLocator);
                }
            }
            throw new IllegalStateException("Unsupported configuration reload mode: " + (Object)((Object)properties.getMode()));
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx, @Autowired(required=false) RestartEndpoint restarter, ContextRefresher refresher) {
            switch (properties.getStrategy()) {
                case RESTART_CONTEXT: {
                    Assert.notNull((Object)restarter, (String)"Restart endpoint is not enabled");
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        restarter.restart();
                    });
                }
                case REFRESH: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((ContextRefresher)refresher).refresh());
                }
                case SHUTDOWN: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        ctx.close();
                    });
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + (Object)((Object)properties.getStrategy()));
        }

        private static void wait(ConfigReloadProperties properties) {
            long waitMillis = ThreadLocalRandom.current().nextLong(properties.getMaxWaitForRestart().toMillis());
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

