/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnSpringCloudKubernetesReactiveDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryPodUtils;
import org.springframework.cloud.kubernetes.discovery.KubernetesReactiveDiscoveryClient;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesReactiveDiscovery
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class, KubernetesDiscoveryProperties.class})
class KubernetesDiscoveryClientReactiveAutoConfiguration {
    KubernetesDiscoveryClientReactiveAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    WebClient.Builder webClientBuilder() {
        return WebClient.builder();
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesReactiveDiscoveryClient kubernetesReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryProperties properties) {
        return new KubernetesReactiveDiscoveryClient(webClientBuilder, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    PodUtils<?> kubernetesDiscoveryPodUtils() {
        return new KubernetesDiscoveryPodUtils();
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer reactiveIndicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer
    ReactiveDiscoveryClientHealthIndicator kubernetesReactiveDiscoveryClientHealthIndicator(KubernetesReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
        return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
    }
}

