/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=0)
public class Fabric8ConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final KubernetesClient client;

    public Fabric8ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties) {
        super(properties);
        this.client = client;
    }

    protected MapPropertySource getMapPropertySource(String name, ConfigMapConfigProperties.NormalizedSource normalizedSource, String configurationTarget, ConfigurableEnvironment environment) {
        return new Fabric8ConfigMapPropertySource(this.client, name, Fabric8ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget), (Environment)environment);
    }
}

