/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigOrSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8BootstrapConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.RetryableFabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.RetryableFabric8SecretsPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesEnabled
@AutoConfigureBefore(value={Fabric8BootstrapConfiguration.class})
@Import(value={KubernetesCommonsAutoConfiguration.class, Fabric8AutoConfiguration.class})
@ConditionalOnClass(value={ConfigMap.class, Secret.class})
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnKubernetesConfigOrSecretsRetryEnabled
public class Fabric8RetryBootstrapConfiguration {
    @Bean
    @ConditionalOnKubernetesConfigRetryEnabled
    public Fabric8ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties, KubernetesClient client, KubernetesNamespaceProvider provider) {
        return new RetryableFabric8ConfigMapPropertySourceLocator(client, properties, provider);
    }

    @Bean
    @ConditionalOnKubernetesSecretsRetryEnabled
    public Fabric8SecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties, KubernetesClient client, KubernetesNamespaceProvider provider) {
        return new RetryableFabric8SecretsPropertySourceLocator(client, properties, provider);
    }
}

