/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadUtil;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.log.LogAccessor;

public class Fabric8EventBasedConfigMapChangeDetector
extends ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8EventBasedConfigMapChangeDetector.class));
    private final Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator;
    private final KubernetesClient kubernetesClient;
    private final List<SharedIndexInformer<ConfigMap>> informers = new ArrayList<SharedIndexInformer<ConfigMap>>();
    private final Set<String> namespaces;
    private final boolean enableReloadFiltering;

    public Fabric8EventBasedConfigMapChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, KubernetesNamespaceProvider namespaceProvider) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.kubernetesClient = kubernetesClient;
        this.fabric8ConfigMapPropertySourceLocator = fabric8ConfigMapPropertySourceLocator;
        this.enableReloadFiltering = properties.enableReloadFiltering();
        this.namespaces = Fabric8ConfigUtils.namespaces(kubernetesClient, namespaceProvider, properties, "configmap");
    }

    @PostConstruct
    private void inform() {
        LOG.info((CharSequence)"Kubernetes event-based configMap change detector activated");
        this.namespaces.forEach(namespace -> {
            SharedIndexInformer informer;
            if (this.enableReloadFiltering) {
                informer = ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(namespace)).withLabels(Map.of("spring.cloud.kubernetes.config.informer.enabled", "true"))).inform();
                LOG.debug((CharSequence)("added configmap informer for namespace : " + namespace + " with enabled filter"));
            } else {
                informer = ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(namespace)).inform();
                LOG.debug((CharSequence)("added configmap informer for namespace : " + namespace));
            }
            informer.addEventHandler((ResourceEventHandler)new ConfigMapInformerAwareEventHandler((SharedIndexInformer<ConfigMap>)informer));
            this.informers.add((SharedIndexInformer<ConfigMap>)informer);
        });
    }

    @PreDestroy
    private void shutdown() {
        this.informers.forEach(SharedIndexInformer::close);
        this.kubernetesClient.close();
    }

    protected void onEvent(ConfigMap configMap) {
        boolean reload = ConfigReloadUtil.reload((String)"config-map", (String)configMap.toString(), (PropertySourceLocator)this.fabric8ConfigMapPropertySourceLocator, (ConfigurableEnvironment)this.environment, Fabric8ConfigMapPropertySource.class);
        if (reload) {
            this.reloadProperties();
        }
    }

    private final class ConfigMapInformerAwareEventHandler
    implements ResourceEventHandler<ConfigMap> {
        private final SharedIndexInformer<ConfigMap> informer;

        private ConfigMapInformerAwareEventHandler(SharedIndexInformer<ConfigMap> informer) {
            this.informer = informer;
        }

        public void onAdd(ConfigMap configMap) {
            LOG.debug((CharSequence)("ConfigMap " + configMap.getMetadata().getName() + " was added."));
            Fabric8EventBasedConfigMapChangeDetector.this.onEvent(configMap);
        }

        public void onUpdate(ConfigMap oldConfigMap, ConfigMap newConfigMap) {
            LOG.debug((CharSequence)("ConfigMap " + newConfigMap.getMetadata().getName() + " was updated."));
            Fabric8EventBasedConfigMapChangeDetector.this.onEvent(newConfigMap);
        }

        public void onDelete(ConfigMap configMap, boolean deletedFinalStateUnknown) {
            LOG.debug((CharSequence)("ConfigMap " + configMap.getMetadata().getName() + " was deleted."));
            Fabric8EventBasedConfigMapChangeDetector.this.onEvent(configMap);
        }

        public void onNothing() {
            List store = this.informer.getStore().list();
            LOG.info((CharSequence)("onNothing called with a store of size : " + store.size()));
            LOG.info((CharSequence)"this might be an indication of a HTTP_GONE code");
        }
    }
}

