/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.registry;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;

public class KubernetesRegistration
implements Registration,
Closeable {
    private final KubernetesClient client;
    private KubernetesDiscoveryProperties properties;
    private AtomicBoolean running = new AtomicBoolean(false);

    public KubernetesRegistration(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public String getServiceId() {
        return this.properties.getServiceName();
    }

    public String getHost() {
        return this.client.getMasterUrl().getHost();
    }

    public int getPort() {
        return 0;
    }

    public boolean isSecure() {
        return false;
    }

    public URI getUri() {
        try {
            return this.client.getMasterUrl().toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public KubernetesDiscoveryProperties getProperties() {
        return this.properties;
    }

    public Map<String, String> getMetadata() {
        return null;
    }

    public String toString() {
        return "KubernetesRegistration{client=" + this.client + ", properties=" + this.properties + ", running=" + this.running + '}';
    }
}

