/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatchContext;
import org.springframework.core.log.LogAccessor;

final class Fabric8EndpointsCatalogWatch
implements Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8EndpointsCatalogWatch.class));

    Fabric8EndpointsCatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(Fabric8CatalogWatchContext context) {
        List<Endpoints> endpoints;
        KubernetesClient client = context.kubernetesClient();
        if (context.properties().allNamespaces()) {
            LOG.debug(() -> "discovering endpoints in all namespaces");
            endpoints = ((EndpointsList)((FilterWatchListDeletable)((AnyNamespaceOperation)client.endpoints().inAnyNamespace()).withLabels(context.properties().serviceLabels())).list()).getItems();
        } else if (!context.properties().namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoints in " + context.properties().namespaces());
            ArrayList<Endpoints> inner = new ArrayList<Endpoints>(context.properties().namespaces().size());
            context.properties().namespaces().forEach(namespace -> inner.addAll(this.endpoints(context, (String)namespace, client)));
            endpoints = inner;
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)context.kubernetesClient(), null, (String)"catalog-watcher", (KubernetesNamespaceProvider)context.namespaceProvider());
            LOG.debug(() -> "discovering endpoints in namespace : " + namespace2);
            endpoints = this.endpoints(context, namespace2, client);
        }
        Stream<ObjectReference> references = endpoints.stream().map(Endpoints::getSubsets).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointSubset::getAddresses).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointAddress::getTargetRef);
        return Fabric8CatalogWatchContext.state(references);
    }

    private List<Endpoints> endpoints(Fabric8CatalogWatchContext context, String namespace, KubernetesClient client) {
        return ((EndpointsList)((FilterWatchListDeletable)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withLabels(context.properties().serviceLabels())).list()).getItems();
    }
}

