/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesCatalogEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesCatalogWatch;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class})
public class KubernetesCatalogWatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnKubernetesCatalogEnabled
    public KubernetesCatalogWatch kubernetesCatalogWatch(KubernetesClient client, KubernetesDiscoveryProperties properties, Environment environment) {
        return new KubernetesCatalogWatch(client, properties, new KubernetesNamespaceProvider(environment));
    }
}

