/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterNested;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.EndpointSubsetNS;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8ServicePortData;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class Fabric8KubernetesDiscoveryClientUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8KubernetesDiscoveryClientUtils.class));

    private Fabric8KubernetesDiscoveryClientUtils() {
    }

    static EndpointSubsetNS subsetsFromEndpoints(Endpoints endpoints) {
        return new EndpointSubsetNS(endpoints.getMetadata().getNamespace(), endpoints.getSubsets());
    }

    static Fabric8ServicePortData endpointsPort(EndpointSubset endpointSubset, String serviceId, KubernetesDiscoveryProperties properties, Service service) {
        List endpointPorts = endpointSubset.getPorts();
        if (endpointPorts.size() == 0) {
            LOG.debug(() -> "no ports found for service : " + serviceId + ", will return zero");
            return new Fabric8ServicePortData(0, "http");
        }
        if (endpointPorts.size() == 1) {
            EndpointPort single = (EndpointPort)endpointPorts.get(0);
            int port = single.getPort();
            LOG.debug(() -> "endpoint ports has a single entry, using port : " + port);
            return new Fabric8ServicePortData(single.getPort(), single.getName());
        }
        String primaryPortName = Fabric8KubernetesDiscoveryClientUtils.primaryPortName(properties, service, serviceId);
        Map<String, Integer> existingPorts = endpointPorts.stream().filter(endpointPort -> StringUtils.hasText((String)endpointPort.getName())).collect(Collectors.toMap(EndpointPort::getName, EndpointPort::getPort));
        Optional<Fabric8ServicePortData> portData = Fabric8KubernetesDiscoveryClientUtils.fromMap(existingPorts, primaryPortName, "found primary-port-name (with value: '" + primaryPortName + "') via properties or service labels to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        portData = Fabric8KubernetesDiscoveryClientUtils.fromMap(existingPorts, "https", "found primary-port-name via 'https' to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        portData = Fabric8KubernetesDiscoveryClientUtils.fromMap(existingPorts, "http", "found primary-port-name via 'http' to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        Fabric8KubernetesDiscoveryClientUtils.logWarnings();
        return new Fabric8ServicePortData(((EndpointPort)endpointPorts.get(0)).getPort(), ((EndpointPort)endpointPorts.get(0)).getName());
    }

    static String primaryPortName(KubernetesDiscoveryProperties properties, Service service, String serviceId) {
        String primaryPortNameFromProperties = properties.primaryPortName();
        Map serviceLabels = service.getMetadata().getLabels();
        String primaryPortName = Optional.ofNullable((String)Optional.ofNullable(serviceLabels).orElse(Map.of()).get("primary-port-name")).orElse(primaryPortNameFromProperties);
        if (primaryPortName == null) {
            LOG.debug(() -> "did not find a primary-port-name in neither properties nor service labels for service with ID : " + serviceId);
            return null;
        }
        LOG.debug(() -> "will use primaryPortName : " + primaryPortName + " for service with ID = " + serviceId);
        return primaryPortName;
    }

    static Map<String, String> serviceMetadata(String serviceId, Service service, KubernetesDiscoveryProperties properties, List<EndpointSubset> endpointSubsets, String namespace) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = properties.metadata();
        if (metadataProps.addLabels()) {
            Map labelMetadata = ConfigUtils.keysWithPrefix((Map)service.getMetadata().getLabels(), (String)metadataProps.labelsPrefix());
            LOG.debug(() -> "Adding labels metadata: " + labelMetadata + " for serviceId: " + serviceId);
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.addAnnotations()) {
            Map annotationMetadata = ConfigUtils.keysWithPrefix((Map)service.getMetadata().getAnnotations(), (String)metadataProps.annotationsPrefix());
            LOG.debug(() -> "Adding annotations metadata: " + annotationMetadata + " for serviceId: " + serviceId);
            serviceMetadata.putAll(annotationMetadata);
        }
        if (metadataProps.addPorts()) {
            Map<String, String> ports = endpointSubsets.stream().flatMap(endpointSubset -> endpointSubset.getPorts().stream()).filter(port -> StringUtils.hasText((String)port.getName())).collect(Collectors.toMap(EndpointPort::getName, port -> Integer.toString(port.getPort())));
            Map portMetadata = ConfigUtils.keysWithPrefix(ports, (String)properties.metadata().portsPrefix());
            if (!portMetadata.isEmpty()) {
                LOG.debug(() -> "Adding port metadata: " + portMetadata + " for serviceId : " + serviceId);
            }
            serviceMetadata.putAll(portMetadata);
        }
        serviceMetadata.put("k8s_namespace", namespace);
        serviceMetadata.put("type", service.getSpec().getType());
        return serviceMetadata;
    }

    static List<Endpoints> endpoints(KubernetesDiscoveryProperties properties, KubernetesClient client, KubernetesNamespaceProvider namespaceProvider, String target, @Nullable String serviceName, Predicate<Service> filter) {
        List<Endpoints> endpoints;
        if (properties.allNamespaces()) {
            LOG.debug(() -> "discovering endpoints in all namespaces");
            endpoints = Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((AnyNamespaceOperation)client.endpoints().inAnyNamespace()).withNewFilter(), properties, serviceName);
        } else if (!properties.namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoints in namespaces : " + properties.namespaces());
            ArrayList<Endpoints> inner = new ArrayList<Endpoints>(properties.namespaces().size());
            properties.namespaces().forEach(namespace -> inner.addAll(Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withNewFilter(), properties, serviceName)));
            endpoints = inner;
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)namespaceProvider);
            LOG.debug(() -> "discovering endpoints in namespace : " + namespace2);
            endpoints = Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((NonNamespaceOperation)client.endpoints().inNamespace(namespace2)).withNewFilter(), properties, serviceName);
        }
        return Fabric8KubernetesDiscoveryClientUtils.withFilter(endpoints, properties, client, filter);
    }

    static List<Endpoints> withFilter(List<Endpoints> initial, KubernetesDiscoveryProperties properties, KubernetesClient client, Predicate<Service> filter) {
        if (properties.filter() == null || properties.filter().isBlank()) {
            LOG.debug(() -> "filter not present");
            return initial;
        }
        ArrayList<Endpoints> result = new ArrayList<Endpoints>();
        Map<String, List<Endpoints>> byNamespace = initial.stream().collect(Collectors.groupingBy(x -> x.getMetadata().getNamespace()));
        for (Map.Entry<String, List<Endpoints>> entry : byNamespace.entrySet()) {
            Set withFilter = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(entry.getKey())).list()).getItems().stream().filter(filter).map(service -> service.getMetadata().getName()).collect(Collectors.toSet());
            result.addAll(entry.getValue().stream().filter(x -> withFilter.contains(x.getMetadata().getName())).toList());
        }
        return result;
    }

    static List<Endpoints> filteredEndpoints(FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>> filterNested, KubernetesDiscoveryProperties properties, @Nullable String serviceName) {
        FilterNested partial = (FilterNested)filterNested.withLabels(properties.serviceLabels());
        if (serviceName != null) {
            partial = (FilterNested)partial.withField("metadata.name", serviceName);
        }
        return ((EndpointsList)((FilterWatchListDeletable)partial.endFilter()).list()).getItems();
    }

    static List<EndpointAddress> addresses(EndpointSubset endpointSubset, KubernetesDiscoveryProperties properties) {
        List addresses = Optional.ofNullable(endpointSubset.getAddresses()).map(ArrayList::new).orElse(new ArrayList());
        if (properties.includeNotReadyAddresses()) {
            List notReadyAddresses = endpointSubset.getNotReadyAddresses();
            if (CollectionUtils.isEmpty((Collection)notReadyAddresses)) {
                return addresses;
            }
            addresses.addAll(notReadyAddresses);
        }
        return addresses;
    }

    static ServiceInstance serviceInstance(@Nullable ServicePortSecureResolver servicePortSecureResolver, Service service, @Nullable EndpointAddress endpointAddress, Fabric8ServicePortData portData, String serviceId, Map<String, String> serviceMetadata, String namespace, KubernetesDiscoveryProperties properties, KubernetesClient client) {
        String instanceId = Optional.ofNullable(endpointAddress).map(EndpointAddress::getTargetRef).map(ObjectReference::getUid).orElseGet(() -> service.getMetadata().getUid());
        boolean secured = servicePortSecureResolver == null ? false : servicePortSecureResolver.resolve(new ServicePortSecureResolver.Input(portData, service.getMetadata().getName(), service.getMetadata().getLabels(), service.getMetadata().getAnnotations()));
        String host = Optional.ofNullable(endpointAddress).map(EndpointAddress::getIp).orElseGet(() -> service.getSpec().getExternalName());
        Map<String, Map<String, String>> podMetadata = Fabric8KubernetesDiscoveryClientUtils.podMetadata(client, serviceMetadata, properties, endpointAddress, namespace);
        return new DefaultKubernetesServiceInstance(instanceId, serviceId, host, portData.portNumber(), serviceMetadata, secured, namespace, null, podMetadata);
    }

    static List<Service> services(KubernetesDiscoveryProperties properties, KubernetesClient client, KubernetesNamespaceProvider namespaceProvider, Predicate<Service> predicate, Map<String, String> fieldFilters, String target) {
        List<Service> services;
        if (properties.allNamespaces()) {
            LOG.debug(() -> "discovering services in all namespaces");
            services = Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((AnyNamespaceOperation)client.services().inAnyNamespace()).withNewFilter(), properties, predicate, fieldFilters);
        } else if (!properties.namespaces().isEmpty()) {
            LOG.debug(() -> "discovering services in namespaces : " + properties.namespaces());
            ArrayList<Service> inner = new ArrayList<Service>(properties.namespaces().size());
            properties.namespaces().forEach(namespace -> inner.addAll(Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((NonNamespaceOperation)client.services().inNamespace(namespace)).withNewFilter(), properties, predicate, fieldFilters)));
            services = inner;
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)namespaceProvider);
            LOG.debug(() -> "discovering services in namespace : " + namespace2);
            services = Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((NonNamespaceOperation)client.services().inNamespace(namespace2)).withNewFilter(), properties, predicate, fieldFilters);
        }
        return services;
    }

    static Map<String, Map<String, String>> podMetadata(KubernetesClient client, Map<String, String> serviceMetadata, KubernetesDiscoveryProperties properties, EndpointAddress endpointAddress, String namespace) {
        String podName;
        if (!"ExternalName".equals(serviceMetadata.get("type")) && (properties.metadata().addPodLabels() || properties.metadata().addPodAnnotations()) && (podName = (String)Optional.ofNullable(endpointAddress).map(EndpointAddress::getTargetRef).filter(objectReference -> "Pod".equals(objectReference.getKind())).map(ObjectReference::getName).orElse(null)) != null) {
            ObjectMeta metadata = Optional.ofNullable((Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get()).map(Pod::getMetadata).orElse(new ObjectMeta());
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            if (properties.metadata().addPodLabels() && !metadata.getLabels().isEmpty()) {
                result.put("labels", metadata.getLabels());
            }
            if (properties.metadata().addPodAnnotations() && !metadata.getAnnotations().isEmpty()) {
                result.put("annotations", metadata.getAnnotations());
            }
            LOG.debug(() -> "adding podMetadata : " + result + " from pod : " + podName);
            return result;
        }
        return Map.of();
    }

    private static List<Service> filteredServices(FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>> filterNested, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, @Nullable Map<String, String> fieldFilters) {
        FilterNested partial = (FilterNested)filterNested.withLabels(properties.serviceLabels());
        if (fieldFilters != null) {
            partial = (FilterNested)partial.withFields(fieldFilters);
        }
        return ((ServiceList)((FilterWatchListDeletable)partial.endFilter()).list()).getItems().stream().filter(predicate).toList();
    }

    private static Optional<Fabric8ServicePortData> fromMap(Map<String, Integer> existingPorts, String key, String message) {
        Integer fromPrimaryPortName = existingPorts.get(key);
        if (fromPrimaryPortName == null) {
            LOG.debug(() -> "not " + message);
            return Optional.empty();
        }
        LOG.debug(() -> message + " : " + fromPrimaryPortName);
        return Optional.of(new Fabric8ServicePortData(fromPrimaryPortName, key));
    }

    private static void logWarnings() {
        LOG.warn(() -> "Make sure that either the primary-port-name label has been added to the service,\nor spring.cloud.kubernetes.discovery.primary-port-name has been configured.\nAlternatively name the primary port 'https' or 'http'\nAn incorrect configuration may result in non-deterministic behaviour.");
    }
}

