/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.APIResource;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GroupVersionForDiscovery;
import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatchContext;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8EndpointSliceV1CatalogWatch;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8EndpointsCatalogWatch;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.scheduling.annotation.Scheduled;

public class KubernetesCatalogWatch
implements ApplicationEventPublisherAware {
    private static final String DISCOVERY_GROUP_VERSION = "discovery.k8s.io/v1";
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesCatalogWatch.class));
    private final Fabric8CatalogWatchContext context;
    private Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> stateGenerator;
    private volatile List<EndpointNameAndNamespace> catalogEndpointsState = null;
    private ApplicationEventPublisher publisher;

    public KubernetesCatalogWatch(KubernetesClient kubernetesClient, KubernetesDiscoveryProperties properties, KubernetesNamespaceProvider namespaceProvider) {
        this.context = new Fabric8CatalogWatchContext(kubernetesClient, properties, namespaceProvider);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.kubernetes.discovery.catalogServicesWatchDelay:30000}")
    public void catalogServicesWatch() {
        try {
            List<EndpointNameAndNamespace> currentState = this.stateGenerator.apply(this.context);
            if (!currentState.equals(this.catalogEndpointsState)) {
                LOG.debug(() -> "Received endpoints update from kubernetesClient: " + currentState);
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, currentState));
            }
            this.catalogEndpointsState = currentState;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, () -> "Error watching Kubernetes Services");
        }
    }

    @PostConstruct
    void postConstruct() {
        this.stateGenerator = this.stateGenerator();
    }

    Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> stateGenerator() {
        Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> localStateGenerator;
        if (this.context.properties().useEndpointSlices()) {
            KubernetesClient client = this.context.kubernetesClient();
            boolean found = client.getApiGroups().getGroups().stream().flatMap(x -> x.getVersions().stream()).map(GroupVersionForDiscovery::getGroupVersion).filter(DISCOVERY_GROUP_VERSION::equals).findFirst().map(arg_0 -> ((KubernetesClient)client).getApiResources(arg_0)).map(APIResourceList::getResources).map(x -> x.stream().map(APIResource::getKind)).flatMap(x -> x.filter(y -> y.equals("EndpointSlice")).findFirst()).isPresent();
            if (!found) {
                throw new IllegalArgumentException("EndpointSlices are not supported on the cluster");
            }
            localStateGenerator = new Fabric8EndpointSliceV1CatalogWatch();
        } else {
            localStateGenerator = new Fabric8EndpointsCatalogWatch();
        }
        LOG.debug(() -> "stateGenerator is of type: " + localStateGenerator.getClass().getSimpleName());
        return localStateGenerator;
    }
}

